/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.misc;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.algart.arrays.MutableLongArray;
import net.algart.executors.modules.opencv.matrices.misc.TestBorderPixels;
import org.bytedeco.opencv.opencv_core.Mat;

class CirclePointsBuilder {
    public static final int MAXIMAL_APERTURE_DIAMETER = 1000000;
    private final boolean removeDuplicates;
    private volatile double diameter = 0.0;
    private volatile int dimX = 0;
    private volatile int dimY = 0;
    private volatile int[] pointsXY = null;
    private volatile byte[] savedPixels = null;

    public CirclePointsBuilder(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public CirclePointsBuilder() {
        this(true);
    }

    public double getDiameter() {
        return this.diameter;
    }

    public CirclePointsBuilder setDiameter(double diameter) {
        if (diameter < 0.0) {
            throw new IllegalArgumentException("Negative diameter = " + diameter);
        }
        if (diameter > 1000000.0) {
            throw new IllegalArgumentException("Too large aperture size " + diameter + ": it must not be greater than 1000000");
        }
        boolean changed = diameter != this.diameter;
        this.diameter = diameter;
        if (changed) {
            this.clearCache();
        }
        return this;
    }

    public int getDimX() {
        return this.dimX;
    }

    public int getDimY() {
        return this.dimY;
    }

    public CirclePointsBuilder setDimensions(int dimX, int dimY) {
        if (dimX < 0) {
            throw new IllegalArgumentException("Negative dimX = " + dimX);
        }
        if (dimY < 0) {
            throw new IllegalArgumentException("Negative dimY = " + dimY);
        }
        boolean changed = dimX != this.dimX || dimY != this.dimY;
        this.dimX = dimX;
        this.dimY = dimY;
        if (changed) {
            this.clearCache();
        }
        return this;
    }

    public void clear() {
        this.dimX = 0;
        this.diameter = 0.0;
        this.clearCache();
    }

    public int[] pointsXY() {
        int[] pointsXY = this.pointsXY;
        if (pointsXY == null) {
            long[] packedPoints = this.buildPackedPointsOf4ConnectedCircle();
            if (this.removeDuplicates) {
                packedPoints = CirclePointsBuilder.sortAndRemoveDuplicates(packedPoints);
            }
            this.pointsXY = pointsXY = CirclePointsBuilder.unpackPoints(packedPoints);
            this.savedPixels = new byte[pointsXY.length];
        }
        return pointsXY;
    }

    public void drawAndSavePrevious(Mat mat, long centerX, long centerY, byte value) {
        if (mat.type() != 0) {
            throw new IllegalArgumentException("Illegal mat type (must be CV_8U): " + mat);
        }
        int[] pointsXY = this.pointsXY();
        if (pointsXY.length == 0) {
            return;
        }
        int dimX = mat.cols();
        int dimY = mat.rows();
        ByteBuffer maskBytes = TestBorderPixels.asByteBuffer(mat);
        int disp = 0;
        int k = 0;
        while (disp < pointsXY.length) {
            long x = centerX + (long)pointsXY[disp++];
            long y = centerY + (long)pointsXY[disp++];
            if (x >= 0L && x < (long)dimX && y >= 0L && y < (long)dimY) {
                int offset = (int)y * dimX + (int)x;
                this.savedPixels[k] = maskBytes.get(offset);
                maskBytes.put(offset, value);
            }
            ++k;
        }
    }

    public void restorePrevious(Mat mask, long centerX, long centerY) {
        if (mask.type() != 0) {
            throw new IllegalArgumentException("Illegal  mask type (must be CV_8U): " + mask);
        }
        int[] pointsXY = this.pointsXY();
        if (pointsXY.length == 0) {
            return;
        }
        int dimX = mask.cols();
        int dimY = mask.rows();
        ByteBuffer maskBytes = TestBorderPixels.asByteBuffer(mask);
        int disp = 0;
        int k = 0;
        while (disp < pointsXY.length) {
            long x = centerX + (long)pointsXY[disp++];
            long y = centerY + (long)pointsXY[disp++];
            if (x >= 0L && x < (long)dimX && y >= 0L && y < (long)dimY) {
                int offset = (int)y * dimX + (int)x;
                maskBytes.put(offset, this.savedPixels[k]);
            }
            ++k;
        }
    }

    public String toString() {
        return "CirclePointsBuilder" + (this.removeDuplicates ? "" : " with duplicates") + ": diameter=" + this.diameter + ", dimX=" + this.dimX + ", dimY=" + this.dimY + (String)(this.pointsXY == null ? ", not built yet" : ", " + this.pointsXY.length / 2 + " points");
    }

    private void clearCache() {
        this.pointsXY = null;
        this.savedPixels = null;
    }

    private long[] buildPackedPointsOf4ConnectedCircle() {
        MutableLongArray packedPoints = net.algart.arrays.Arrays.SMM.newEmptyLongArray();
        if (this.dimX > 0 && this.dimY > 0 && this.diameter > 0.0) {
            int x;
            double rSqr = 0.25 * this.diameter * this.diameter;
            int y = 0;
            int lastX = x = (int)Math.ceil(0.5 * this.diameter);
            do {
                this.add8Points(packedPoints, lastX, y);
                lastX = x;
                x = CirclePointsBuilder.finxX(++y, rSqr);
                while (lastX > x) {
                    this.add8Points(packedPoints, lastX, y);
                    --lastX;
                }
            } while (y <= x);
        }
        return packedPoints.toJavaArray();
    }

    private static int finxX(double y, double rSqr) {
        double xSqr = rSqr - y * y;
        return xSqr <= 0.0 ? 0 : (int)Math.ceil(Math.sqrt(xSqr));
    }

    private void add8Points(MutableLongArray packedPoints, int x, int y) {
        assert (x >= 0);
        assert (y >= 0);
        if (x < this.dimX && y < this.dimY) {
            CirclePointsBuilder.addPoint(packedPoints, x, y);
            CirclePointsBuilder.addPoint(packedPoints, y, x);
            CirclePointsBuilder.addPoint(packedPoints, -x, y);
            CirclePointsBuilder.addPoint(packedPoints, -y, x);
            CirclePointsBuilder.addPoint(packedPoints, x, -y);
            CirclePointsBuilder.addPoint(packedPoints, y, -x);
            CirclePointsBuilder.addPoint(packedPoints, -x, -y);
            CirclePointsBuilder.addPoint(packedPoints, -y, -x);
        }
    }

    private static void addPoint(MutableLongArray packedPoints, int x, int y) {
        long p = ((long)y & 0xFFFFFFFFL) << 32 | (long)x & 0xFFFFFFFFL;
        assert (x == (int)p);
        assert (y == (int)(p >>> 32));
        packedPoints.pushLong(p);
    }

    private static long[] sortAndRemoveDuplicates(long[] array) {
        if (array.length == 0) {
            return array;
        }
        Arrays.parallelSort(array);
        int n = 1;
        for (int k = 1; k < array.length; ++k) {
            long a = array[k];
            if (a == array[k - 1]) continue;
            array[n++] = a;
        }
        return Arrays.copyOf(array, n);
    }

    private static int[] unpackPoints(long[] packedPoints) {
        int[] pointsXY = new int[Math.multiplyExact(2, packedPoints.length)];
        int disp = 0;
        for (long p : packedPoints) {
            int x = (int)p;
            int y = (int)(p >>> 32);
            pointsXY[disp++] = x;
            pointsXY[disp++] = y;
        }
        return pointsXY;
    }

    public static void main(String[] args) {
        long[] array = new long[]{1L, -2L, 2L, 50L, 2L, 50L, 3L, 1L, 3L};
        System.out.println("Array:              " + Arrays.toString(array));
        array = CirclePointsBuilder.sortAndRemoveDuplicates(array);
        System.out.println("Without duplicates: " + Arrays.toString(array));
        array = new long[]{32L};
        System.out.println("Array:              " + Arrays.toString(array));
        array = CirclePointsBuilder.sortAndRemoveDuplicates(array);
        System.out.println("Without duplicates: " + Arrays.toString(array));
        CirclePointsBuilder builder = new CirclePointsBuilder();
        CirclePointsBuilder builderDup = new CirclePointsBuilder(false);
        System.out.printf("%s:%n    %s%n", builder, Arrays.toString(builder.pointsXY()));
        System.out.printf("%s:%n    %s%n", builderDup, Arrays.toString(builderDup.pointsXY()));
        builder.setDiameter(2.0).setDimensions(1000, 1000);
        System.out.printf("%s:%n    %s%n", builder, Arrays.toString(builder.pointsXY()));
        System.out.printf("%s:%n    %s%n", builderDup, Arrays.toString(builderDup.pointsXY()));
    }
}

