/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.geometry;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.enums.OInterpolation;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Resize
extends UMatFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    private double dimX = 0.0;
    private double dimY = 0.0;
    private boolean percents = false;
    private OInterpolation interpolation = OInterpolation.INTER_LINEAR;

    public Resize() {
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
    }

    public double getDimX() {
        return this.dimX;
    }

    public void setDimX(double dimX) {
        this.dimX = Resize.nonNegative((double)dimX);
    }

    public double getDimY() {
        return this.dimY;
    }

    public void setDimY(double dimY) {
        this.dimY = Resize.nonNegative((double)dimY);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public void setPercents(boolean percents) {
        this.percents = percents;
    }

    public OInterpolation getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(OInterpolation interpolation) {
        this.interpolation = (OInterpolation)((Object)Resize.nonNull((Object)((Object)interpolation)));
    }

    @Override
    public Mat process(Mat source) {
        int newDimX = source.cols();
        int newDimY = source.rows();
        if (this.dimX != 0.0 || this.dimY != 0.0) {
            if (this.dimX != 0.0) {
                int n = newDimX = this.percents ? Math.round((float)(this.dimX / 100.0 * (double)source.cols())) : Math.round((float)this.dimX);
            }
            if (this.dimY != 0.0) {
                int n = newDimY = this.percents ? Math.round((float)(this.dimY / 100.0 * (double)source.rows())) : Math.round((float)this.dimY);
            }
            if (this.dimX == 0.0) {
                newDimX = Math.round((float)newDimX * (float)newDimY / (float)source.rows());
            }
            if (this.dimY == 0.0) {
                newDimY = Math.round((float)newDimY * (float)newDimX / (float)source.cols());
            }
        }
        if (LOGGABLE_DEBUG) {
            Resize.logDebug((String)("Resizing to " + newDimX + "x" + newDimY + " (source: " + source + ")"));
        }
        try (Size size = new Size(newDimX, newDimY);){
            Mat result = new Mat(size, source.type());
            opencv_imgproc.resize((Mat)source, (Mat)result, (Size)size);
            Mat mat = result;
            return mat;
        }
    }

    @Override
    public UMat process(UMat source) {
        int newDimX = source.cols();
        int newDimY = source.rows();
        if (this.dimX != 0.0 || this.dimY != 0.0) {
            if (this.dimX != 0.0) {
                int n = newDimX = this.percents ? Math.round((float)(this.dimX / 100.0 * (double)source.cols())) : Math.round((float)this.dimX);
            }
            if (this.dimY != 0.0) {
                int n = newDimY = this.percents ? Math.round((float)(this.dimY / 100.0 * (double)source.rows())) : Math.round((float)this.dimY);
            }
            if (this.dimX == 0.0) {
                newDimX = Math.round((float)newDimX * (float)newDimY / (float)source.rows());
            }
            if (this.dimY == 0.0) {
                newDimY = Math.round((float)newDimY * (float)newDimX / (float)source.cols());
            }
        }
        if (LOGGABLE_DEBUG) {
            Resize.logDebug((String)("Resizing (GPU) to " + newDimX + "x" + newDimY + " (source: " + source + ")"));
        }
        try (Size size = new Size(newDimX, newDimY);){
            UMat result = new UMat(size, source.type());
            opencv_imgproc.resize((UMat)source, (UMat)result, (Size)size);
            this.getScalar(OUTPUT_DIM_X).setTo(newDimX);
            this.getScalar(OUTPUT_DIM_Y).setTo(newDimY);
            UMat uMat = result;
            return uMat;
        }
    }
}

