/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.enums.OInterpolation;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class BilateralTextureFilter
extends VoidResultUMatFilter {
    private int filterRadius = 5;
    private int numberOfIterations = 3;
    private double sigmaAlpha = -1.0;
    private double sigmaAvg = -1.0;

    public BilateralTextureFilter() {
        this.setStretchingInterpolation(OInterpolation.INTER_LINEAR);
    }

    public int getFilterRadius() {
        return this.filterRadius;
    }

    public void setFilterRadius(int filterRadius) {
        this.filterRadius = BilateralTextureFilter.positive((int)filterRadius, (String)"diameter of neighborhood");
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = BilateralTextureFilter.positive((int)numberOfIterations);
    }

    public double getSigmaAlpha() {
        return this.sigmaAlpha;
    }

    public void setSigmaAlpha(double sigmaAlpha) {
        this.sigmaAlpha = sigmaAlpha;
    }

    public double getSigmaAvg() {
        return this.sigmaAvg;
    }

    public void setSigmaAvg(double sigmaAvg) {
        this.sigmaAvg = sigmaAvg;
    }

    @Override
    public void process(Mat result, Mat source) {
        BilateralTextureFilter.logDebug(() -> "Bilateral texture filter: fr = " + this.filterRadius + ", sigmaAlpha = " + this.sigmaAlpha + ", sigmaAvg = " + this.sigmaAvg + " (source: " + source + ")");
        opencv_ximgproc.bilateralTextureFilter((Mat)source, (Mat)result, (int)this.filterRadius, (int)this.numberOfIterations, (double)this.sigmaAlpha, (double)this.sigmaAvg);
    }

    @Override
    public void process(UMat result, UMat source) {
        BilateralTextureFilter.logDebug(() -> "Bilateral texture filter (GPU): fr = " + this.filterRadius + ", sigmaAlpha = " + this.sigmaAlpha + ", sigmaAvg = " + this.sigmaAvg + " (source: " + source + ")");
        opencv_ximgproc.bilateralTextureFilter((UMat)source, (UMat)result, (int)this.filterRadius, (int)this.numberOfIterations, (double)this.sigmaAlpha, (double)this.sigmaAvg);
    }
}

