/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.pixels;

import java.lang.reflect.Array;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToNumbers;
import net.algart.multimatrix.MultiMatrix;

public final class GetPixelAtPosition
extends MultiMatrixToNumbers {
    public static final String INPUT_POSITIONS = "positions";
    private long x;
    private long y;
    private boolean rawPixelValues = false;

    public GetPixelAtPosition() {
        this.addInputNumbers(INPUT_POSITIONS);
    }

    public long getX() {
        return this.x;
    }

    public void setX(long x) {
        this.x = GetPixelAtPosition.nonNegative((long)x);
    }

    public long getY() {
        return this.y;
    }

    public void setY(long y) {
        this.y = GetPixelAtPosition.nonNegative((long)y);
    }

    public boolean isRawPixelValues() {
        return this.rawPixelValues;
    }

    public void setRawPixelValues(boolean rawPixelValues) {
        this.rawPixelValues = rawPixelValues;
    }

    public SNumbers analyse(MultiMatrix source) {
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        return this.analyse(source, positions);
    }

    public SNumbers analyse(MultiMatrix source, SNumbers positions) {
        long[] xy = new long[]{this.x, this.y};
        if (positions != null && positions.isInitialized()) {
            if (positions.getBlockLength() < 2) {
                throw new IllegalArgumentException("Positions must contain at least 2 elements per block");
            }
            if (positions.getBlockLength() > 2) {
                positions = positions.columnRange(0, 2);
            }
            xy = positions.toLongArray();
        }
        int n = xy.length / 2;
        int blockLength = source.numberOfChannels();
        SNumbers.checkDimensions((long)n, (long)blockLength);
        MultiMatrix.PixelValue pixel = null;
        if (this.rawPixelValues) {
            if (source.elementType() == Boolean.TYPE) {
                byte[] result = new byte[n * blockLength];
                int i = 0;
                int disp = 0;
                while (i < n) {
                    pixel = source.getPixel(source.indexInArray(new long[]{xy[2 * i], xy[2 * i + 1]}), pixel);
                    for (int j = 0; j < blockLength; ++j) {
                        result[disp + j] = (byte)pixel.getChannel(j);
                    }
                    ++i;
                    disp += blockLength;
                }
                return SNumbers.ofArray((Object)result, (int)blockLength);
            }
            if (source.elementType() == Character.TYPE) {
                float[] result = new float[n * blockLength];
                float[] channels = null;
                int i = 0;
                int disp = 0;
                while (i < n) {
                    pixel = source.getPixel(source.indexInArray(new long[]{xy[2 * i], xy[2 * i + 1]}), pixel);
                    channels = pixel.getFloatChannels(channels);
                    System.arraycopy(channels, 0, result, disp, blockLength);
                    ++i;
                    disp += blockLength;
                }
                return SNumbers.ofArray((Object)result, (int)blockLength);
            }
            Object result = Array.newInstance(source.elementType(), n * blockLength);
            Object channels = null;
            int i = 0;
            int disp = 0;
            while (i < n) {
                pixel = source.getPixel(source.indexInArray(new long[]{xy[2 * i], xy[2 * i + 1]}), pixel);
                channels = pixel.getChannels(channels);
                System.arraycopy(channels, 0, result, disp, blockLength);
                ++i;
                disp += blockLength;
            }
            return SNumbers.ofArray((Object)result, (int)blockLength);
        }
        float[] result = new float[n * blockLength];
        double mult = 1.0 / source.maxPossibleValue();
        float[] channels = null;
        int i = 0;
        int disp = 0;
        while (i < n) {
            pixel = source.getPixel(source.indexInArray(new long[]{xy[2 * i], xy[2 * i + 1]}), pixel);
            channels = pixel.getFloatChannels(channels);
            int j = 0;
            while (j < channels.length) {
                int n2 = j++;
                channels[n2] = (float)((double)channels[n2] * mult);
            }
            System.arraycopy(channels, 0, result, disp, blockLength);
            ++i;
            disp += blockLength;
        }
        return SNumbers.ofArray((Object)result, (int)blockLength);
    }
}

