/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.ArraySelector;
import net.algart.arrays.ByteArraySelector;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinder;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannelFor1ResultChannels;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannelFor2ResultChannels;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannelFor3ResultChannels;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannelFor4ResultChannels;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannelFor5ResultChannels;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderForSeparateChannels;

class PercentilesFinderByLastChannel
extends PercentilesFinderForSeparateChannels {
    private static final int NUMBER_OF_SERVICE_CHANNELS = 2;
    final double[] commonLevels;
    final double[] commonSortedLevels;
    final int[] commonUnsortedLevelsIndexes;
    final boolean[] separateChannelsSet;

    PercentilesFinderByLastChannel(int numberOfChannels, int maxLabel, double[][] levelsByChannels, int lowTruncatedMeanIndex, int highTruncatedMeanIndex, boolean[] separateChannelsSet) {
        super(numberOfChannels, numberOfChannels - 2, maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex);
        Objects.requireNonNull(separateChannelsSet, "Null separateChannelsSet");
        this.commonLevels = this.levels[0];
        this.commonSortedLevels = this.sortedLevels[0];
        this.commonUnsortedLevelsIndexes = this.unsortedLevelsIndexes[0];
        if (lowTruncatedMeanIndex >= this.commonLevels.length || highTruncatedMeanIndex >= this.commonLevels.length) {
            throw new IllegalArgumentException("Low or high level index for truncated mean >= " + this.commonLevels.length + " (number of levels)");
        }
        this.separateChannelsSet = Arrays.copyOf(separateChannelsSet, this.numberOfResultChannels);
    }

    public static PercentilesFinder getInstance(int numberOfChannels, int maxLabel, double[][] levelsByChannels, int lowTruncatedMeanIndex, int highTruncatedMeanIndex, boolean[] separateChannelsSet) {
        Objects.requireNonNull(separateChannelsSet, "Null separateChannelsSet");
        boolean allSeparated = true;
        int numberOfResultChannels = numberOfChannels - 2;
        for (int k = 0; k < numberOfResultChannels; ++k) {
            allSeparated &= k < separateChannelsSet.length && separateChannelsSet[k];
        }
        if (allSeparated) {
            return new PercentilesFinderForSeparateChannels(numberOfResultChannels, numberOfResultChannels, maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex);
        }
        switch (numberOfResultChannels) {
            case 1: {
                return new PercentilesFinderByLastChannelFor1ResultChannels(maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
            }
            case 2: {
                return new PercentilesFinderByLastChannelFor2ResultChannels(maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
            }
            case 3: {
                return new PercentilesFinderByLastChannelFor3ResultChannels(maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
            }
            case 4: {
                return new PercentilesFinderByLastChannelFor4ResultChannels(maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
            }
            case 5: {
                return new PercentilesFinderByLastChannelFor5ResultChannels(maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
            }
        }
        return new PercentilesFinderByLastChannel(numberOfChannels, maxLabel, levelsByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
    }

    @Override
    public void preprocess(Class<?> elementType, int numberOfTasks) {
        super.preprocess(elementType, numberOfTasks);
    }

    @Override
    public void processPixels(int objectLabel, byte[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                for (int k = 0; k < this.commonLevels.length; ++k) {
                    this.percentilesByChannels[c][k][resultDisp] = Float.NaN;
                }
                if (!this.needTruncatedMeans) continue;
                this.truncatedMeansByChannels[c][resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        if (numberOfPixels >= 128) {
            this.percentilesForBytes(resultDisp, objectPixelsByChannels, numberOfPixels, this.threadBytePercentiles[threadIndex], this.threadByteArraySelectors[threadIndex]);
            return;
        }
        byte[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        byte[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            byte selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][k][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            byte preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            byte preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow & 0xFF;
            double high = preciseHigh & 0xFF;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                byte precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }

    void processSeparatedPercentiles(int resultDisp, byte[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (numberOfPixels >= 128) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (!this.separateChannelsSet[c]) continue;
                super.percentilesInChannelForBytes(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.sortedLevels[c], this.unsortedLevelsIndexes[c], this.threadBytePercentiles[threadIndex], this.threadByteArraySelectors[threadIndex]);
            }
            return;
        }
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            if (!this.separateChannelsSet[c]) continue;
            super.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    @Override
    public void processPixels(int objectLabel, short[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                for (int k = 0; k < this.commonLevels.length; ++k) {
                    this.percentilesByChannels[c][k][resultDisp] = Float.NaN;
                }
                if (!this.needTruncatedMeans) continue;
                this.truncatedMeansByChannels[c][resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        short[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        short[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            short selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFFFF);
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][k][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            short preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            short preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow & 0xFFFF;
            double high = preciseHigh & 0xFFFF;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                short precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFFFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFFFF);
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + (double)(objectPixelsByChannels[c][j] & 0xFFFF);
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + (double)(objectPixelsByChannels[c][j] & 0xFFFF);
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }

    void processSeparatedPercentiles(int resultDisp, short[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            if (!this.separateChannelsSet[c]) continue;
            super.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    @Override
    public void processPixels(int objectLabel, int[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                for (int k = 0; k < this.commonLevels.length; ++k) {
                    this.percentilesByChannels[c][k][resultDisp] = Float.NaN;
                }
                if (!this.needTruncatedMeans) continue;
                this.truncatedMeansByChannels[c][resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        int[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        int[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            int selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + (double)objectPixelsByChannels[c][j];
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][k][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            int preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            int preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                int precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + (double)objectPixelsByChannels[c][j];
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + (double)objectPixelsByChannels[c][j];
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + (double)objectPixelsByChannels[c][j];
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }

    void processSeparatedPercentiles(int resultDisp, int[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            if (!this.separateChannelsSet[c]) continue;
            super.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    @Override
    public void processPixels(int objectLabel, float[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                for (int k = 0; k < this.commonLevels.length; ++k) {
                    this.percentilesByChannels[c][k][resultDisp] = Float.NaN;
                }
                if (!this.needTruncatedMeans) continue;
                this.truncatedMeansByChannels[c][resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        float[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        float[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            float selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + (double)objectPixelsByChannels[c][j];
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][k][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            float preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            float preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                float precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + (double)objectPixelsByChannels[c][j];
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + (double)objectPixelsByChannels[c][j];
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + (double)objectPixelsByChannels[c][j];
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }

    void processSeparatedPercentiles(int resultDisp, float[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            if (!this.separateChannelsSet[c]) continue;
            super.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    @Override
    public void processPixels(int objectLabel, double[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                for (int k = 0; k < this.commonLevels.length; ++k) {
                    this.percentilesByChannels[c][k][resultDisp] = Float.NaN;
                }
                if (!this.needTruncatedMeans) continue;
                this.truncatedMeansByChannels[c][resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        double[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        double[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            double selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + objectPixelsByChannels[c][j];
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][k][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            double preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            double preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                double precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + objectPixelsByChannels[c][j];
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + objectPixelsByChannels[c][j];
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + objectPixelsByChannels[c][j];
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }

    void processSeparatedPercentiles(int resultDisp, double[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            if (!this.separateChannelsSet[c]) continue;
            super.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    private void percentilesForBytes(int resultDisp, byte[][] objectPixelsByChannels, int numberOfPixels, byte[] bytePercentiles, ByteArraySelector selector) {
        byte[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        selector.select(bytePercentiles, this.commonSortedLevels, unchangedObjectPixelLevels, numberOfPixels);
        double[] sum = new double[this.numberOfResultChannels];
        double[] sumLow = new double[this.numberOfResultChannels];
        double[] sumHigh = new double[this.numberOfResultChannels];
        int kLow = -1;
        int kHigh = -1;
        for (int k = 0; k < this.commonLevels.length; ++k) {
            boolean isHigh;
            int unsortedIndex = this.commonUnsortedLevelsIndexes[k];
            boolean isLow = unsortedIndex == this.lowTruncatedMeanIndex;
            boolean bl = isHigh = unsortedIndex == this.highTruncatedMeanIndex;
            if (this.needTruncatedMeans && (isLow || isHigh)) {
                if (isLow) {
                    kLow = k;
                }
                if (!isHigh) continue;
                kHigh = k;
                continue;
            }
            byte selectedLevel = bytePercentiles[k];
            Arrays.fill(sum, 0.0);
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                for (int c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                }
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][unsortedIndex][resultDisp] = (float)(sum[c] * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            assert (kLow >= 0);
            assert (kHigh >= 0);
            byte preciseLow = bytePercentiles[kLow];
            byte preciseHigh = bytePercentiles[kHigh];
            double low = preciseLow & 0xFF;
            double high = preciseHigh & 0xFF;
            Arrays.fill(sum, 0.0);
            Arrays.fill(sumLow, 0.0);
            Arrays.fill(sumHigh, 0.0);
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int c;
                byte precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sum[n] = sum[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                    }
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    for (c = 0; c < this.numberOfResultChannels; ++c) {
                        int n = c;
                        sumLow[n] = sumLow[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                    }
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                for (c = 0; c < this.numberOfResultChannels; ++c) {
                    int n = c;
                    sumHigh[n] = sumHigh[n] + (double)(objectPixelsByChannels[c][j] & 0xFF);
                }
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (this.separateChannelsSet[c]) continue;
                this.percentilesByChannels[c][this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow[c] * countLowInv);
                this.percentilesByChannels[c][this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh[c] * countHighInv);
                this.truncatedMeansByChannels[c][resultDisp] = (float)(sum[c] * countInv);
            }
        }
    }
}

