/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator;

abstract class FirstNonZeroCalculator3Channels
extends FirstNonZeroCalculator {
    FirstNonZeroCalculator3Channels(int[] labels) {
        super(labels, 3);
    }

    static class ForDoubles
    extends FirstNonZeroCalculator3Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForDoubles.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0.0 && this.data1[k] == 0.0 && this.data2[k] == 0.0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroFloatValues[disp] = (float)this.data0[index];
                    this.firstNonZeroFloatValues[disp + 1] = (float)this.data1[index];
                    this.firstNonZeroFloatValues[disp + 2] = (float)this.data2[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForFloats
    extends FirstNonZeroCalculator3Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForFloats.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0.0f && this.data1[k] == 0.0f && this.data2[k] == 0.0f) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroFloatValues[disp] = this.data0[index];
                    this.firstNonZeroFloatValues[disp + 1] = this.data1[index];
                    this.firstNonZeroFloatValues[disp + 2] = this.data2[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForInts
    extends FirstNonZeroCalculator3Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForInts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0 && this.data1[k] == 0 && this.data2[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index];
                    this.firstNonZeroIntValues[disp + 1] = this.data1[index];
                    this.firstNonZeroIntValues[disp + 2] = this.data2[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForShorts
    extends FirstNonZeroCalculator3Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForShorts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0 && this.data1[k] == 0 && this.data2[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index] & 0xFFFF;
                    this.firstNonZeroIntValues[disp + 1] = this.data1[index] & 0xFFFF;
                    this.firstNonZeroIntValues[disp + 2] = this.data2[index] & 0xFFFF;
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForBytes
    extends FirstNonZeroCalculator3Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForBytes.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0 && this.data1[k] == 0 && this.data2[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index] & 0xFF;
                    this.firstNonZeroIntValues[disp + 1] = this.data1[index] & 0xFF;
                    this.firstNonZeroIntValues[disp + 2] = this.data2[index] & 0xFF;
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }
}

