/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator1Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator2Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator3Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator4Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator5Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesCalculator;

abstract class CardinalitiesAndSumsCalculator
extends CardinalitiesCalculator {
    final int numberOfChannels;
    final double[][][] threadSums;
    private final double[][][] requestedSums;
    double[] sums;

    CardinalitiesAndSumsCalculator(int[] labels, int numberOfChannels) {
        super(labels);
        this.numberOfChannels = numberOfChannels;
        this.requestedSums = CardinalitiesAndSumsCalculator.requestClearedDoubleArrays(this.numberOfTasks(), numberOfChannels);
        this.threadSums = new double[this.requestedSums.length][][];
        for (int k = 0; k < this.requestedSums.length; ++k) {
            this.threadSums[k] = (double[][])this.requestedSums[k].clone();
        }
    }

    static CardinalitiesAndSumsCalculator getInstance(int[] labels, Object[] channels) {
        Objects.requireNonNull(labels, "Null labels");
        Objects.requireNonNull(channels, "Null channels");
        if (channels.length == 0) {
            throw new IllegalArgumentException("Empty channels array");
        }
        Object channel0 = channels[0];
        if (!CardinalitiesAndSumsCalculator.isArraySupported(channel0)) {
            throw new IllegalArgumentException("Illegal array type: " + channel0);
        }
        for (int k = 1; k < channels.length; ++k) {
            if (channels[k].getClass() == channel0.getClass()) continue;
            throw new IllegalArgumentException("Different type of channels: " + channels[k].getClass() + " != " + channel0.getClass());
        }
        switch (channels.length) {
            case 1: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsCalculator1Channels.ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsCalculator1Channels.ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsCalculator1Channels.ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsCalculator1Channels.ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsCalculator1Channels.ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 2: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsCalculator2Channels.ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsCalculator2Channels.ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsCalculator2Channels.ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsCalculator2Channels.ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsCalculator2Channels.ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 3: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsCalculator3Channels.ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsCalculator3Channels.ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsCalculator3Channels.ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsCalculator3Channels.ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsCalculator3Channels.ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 4: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsCalculator4Channels.ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsCalculator4Channels.ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsCalculator4Channels.ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsCalculator4Channels.ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsCalculator4Channels.ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 5: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsCalculator5Channels.ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsCalculator5Channels.ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsCalculator5Channels.ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsCalculator5Channels.ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsCalculator5Channels.ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
        }
        if (channel0 instanceof byte[]) {
            return new ForBytes(labels, CardinalitiesAndSumsCalculator.castToByte(channels));
        }
        if (channel0 instanceof short[]) {
            return new ForShorts(labels, CardinalitiesAndSumsCalculator.castToShort(channels));
        }
        if (channel0 instanceof int[]) {
            return new ForInts(labels, CardinalitiesAndSumsCalculator.castToInt(channels));
        }
        if (channel0 instanceof float[]) {
            return new ForFloats(labels, CardinalitiesAndSumsCalculator.castToFloat(channels));
        }
        if (channel0 instanceof double[]) {
            return new ForDoubles(labels, CardinalitiesAndSumsCalculator.castToDouble(channels));
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        super.close();
        CardinalitiesAndSumsCalculator.releaseAndClearDoubleArrays(this.requestedSums, this.maxLabel + 1);
    }

    @Override
    protected void finish() {
        super.finish();
        if ((long)this.maxLabel * (long)this.numberOfChannels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large required array for " + this.numberOfChannels + " channels: more that 2^31-1 elements");
        }
        this.sums = new double[this.numberOfChannels * this.maxLabel];
        for (double[][] sums : this.threadSums) {
            for (int c = 0; c < this.numberOfChannels; ++c) {
                if (sums[c].length != sums[0].length) {
                    throw new AssertionError((Object)"Different sums length for different channels!");
                }
                int length = Math.min(this.maxLabel, sums[c].length - 1);
                int k = 1;
                int disp = c;
                while (k <= length) {
                    int n = disp;
                    this.sums[n] = this.sums[n] + sums[c][k];
                    ++k;
                    disp += this.numberOfChannels;
                }
            }
        }
    }

    private static class ForBytes
    extends CardinalitiesAndSumsCalculator {
        private final byte[][] data;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + (double)(this.data[c][k] & 0xFF);
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForShorts
    extends CardinalitiesAndSumsCalculator {
        private final short[][] data;

        public ForShorts(int[] labels, short[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + (double)(this.data[c][k] & 0xFFFF);
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForInts
    extends CardinalitiesAndSumsCalculator {
        private final int[][] data;

        public ForInts(int[] labels, int[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + (double)this.data[c][k];
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForFloats
    extends CardinalitiesAndSumsCalculator {
        private final float[][] data;

        public ForFloats(int[] labels, float[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + (double)this.data[c][k];
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForDoubles
    extends CardinalitiesAndSumsCalculator {
        private final double[][] data;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + this.data[c][k];
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

