/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutablePNumberArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.AbstractScanAndMeasureBoundaries;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundariesScanner;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ProjectionParameter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ScanAndMeasureBoundaries;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.SecondProjectionValue;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ThirdProjectionValue;
import net.algart.matrices.scanning.Boundary2DProjectionMeasurer;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.ContourLineType;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ScanAndMeasureBoundariesProjections
extends AbstractScanAndMeasureBoundaries {
    public static final String OUTPUT_AREA = "area";
    public static final String OUTPUT_PERIMETER = "perimeter";
    public static final String OUTPUT_ALL_PROJECTION = "all_projections";
    public static final String OUTPUT_SELECTED_PROJECTION = "selected_projection";
    public static final String OUTPUT_MEAN_PROJECTION = "mean_projection";
    public static final String OUTPUT_MAX_PROJECTION = "max_projection";
    public static final String OUTPUT_MIN_PROJECTION = "min_projection";
    public static final String OUTPUT_MAX_SIZE_RELATION = "max_size_relation";
    public static final String OUTPUT_MIN_CIRCUMSCRIBED_SQUARE_SIDE = "min_circumscribed_square_side";
    public static final String OUTPUT_SHAPE_FACTOR = "shape_factor";
    public static final String OUTPUT_COMPACT_FACTOR = "compact_factor";
    public static final String OUTPUT_IRREGULARITY_FACTOR = "irregularity_factor";
    public static final String OUTPUT_NESTING_LEVEL = "nesting_level";
    private static final Map<String, ProjectionParameter> OUTPUT_STATISTICS = new LinkedHashMap<String, ProjectionParameter>();
    private SecondProjectionValue secondProjectionValue = SecondProjectionValue.ORTHOGONAL_PROJECTION_DIVIDED_BY_THIS;
    private ThirdProjectionValue thirdProjectionValue = ThirdProjectionValue.NONE;
    private double startDirectionAngleInDegree = 0.0;
    private int numberOfDirections = 2;

    public ScanAndMeasureBoundariesProjections() {
        for (String port : OUTPUT_STATISTICS.keySet()) {
            this.addOutputNumbers(port);
        }
        this.addOutputNumbers("object_label");
        this.addOutputNumbers("internal_boundary");
        this.addOutputScalar("number_of_objects");
    }

    public SecondProjectionValue getSecondProjectionValue() {
        return this.secondProjectionValue;
    }

    public void setSecondProjectionValue(SecondProjectionValue secondProjectionValue) {
        this.secondProjectionValue = (SecondProjectionValue)((Object)ScanAndMeasureBoundariesProjections.nonNull((Object)((Object)secondProjectionValue)));
    }

    public ThirdProjectionValue getThirdProjectionValue() {
        return this.thirdProjectionValue;
    }

    public void setThirdProjectionValue(ThirdProjectionValue thirdProjectionValue) {
        this.thirdProjectionValue = (ThirdProjectionValue)((Object)ScanAndMeasureBoundariesProjections.nonNull((Object)((Object)thirdProjectionValue)));
    }

    public double getStartDirectionAngleInDegree() {
        return this.startDirectionAngleInDegree;
    }

    public void setStartDirectionAngleInDegree(double startDirectionAngleInDegree) {
        this.startDirectionAngleInDegree = startDirectionAngleInDegree;
    }

    public int getNumberOfDirections() {
        return this.numberOfDirections;
    }

    public void setNumberOfDirections(int numberOfDirections) {
        this.numberOfDirections = ScanAndMeasureBoundariesProjections.inRange((int)numberOfDirections, (int)2, (int)65536);
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        Map<ProjectionParameter, SNumbers> resultStatistics = ScanAndMeasureBoundariesProjections.convertMap(this.allOutputContainers(SNumbers.class, true));
        return this.analyse(resultStatistics, BoundariesScanner.toObjects((MultiMatrix)source, this.objectsInterpretation.binaryOnly()), this.isOutputNecessary(this.defaultOutputPortName()));
    }

    public MultiMatrix2D analyse(Map<ProjectionParameter, SNumbers> resultStatistics, Matrix<? extends PFixedArray> objects, boolean resultLabelsRequired) {
        int k;
        Set<ProjectionParameter> parameters = resultStatistics.keySet();
        ProjectionParameter[] parametersArray = parameters.toArray(new ProjectionParameter[0]);
        MutablePNumberArray[] statisticsArray = new MutablePNumberArray[resultStatistics.size()];
        for (int k2 = 0; k2 < parametersArray.length; ++k2) {
            statisticsArray[k2] = parametersArray[k2] == ProjectionParameter.NESTING_LEVEL ? Arrays.SMM.newIntArray(0L) : Arrays.SMM.newFloatArray(0L);
        }
        MutableIntArray objectLabelArray = Arrays.SMM.newEmptyIntArray();
        MutableBitArray internalBoundaryFlags = Arrays.SMM.newEmptyBitArray();
        BoundariesScanner scanner = new BoundariesScanner(objects, this.getConnectivityType(), this.getBoundaryType(), ProjectionParameter.needSecondBuffer(parameters), resultLabelsRequired, this.getMaxLabelLevelOrMaxValue());
        double normalizedStartAngleInDegree = this.startDirectionAngleInDegree % 180.0;
        if (normalizedStartAngleInDegree < 0.0) {
            normalizedStartAngleInDegree += 180.0;
        }
        Boundary2DProjectionMeasurer measurer = Boundary2DProjectionMeasurer.getInstance((Boundary2DScanner)scanner.getBoundaryScanner(), (ContourLineType)this.getContourLineType(), (double)Math.toRadians(normalizedStartAngleInDegree), (int)this.numberOfDirections);
        scanner.setBoundaryMeasurer((Boundary2DScanner)measurer);
        scanner.setProcessBackgroundAsObject(this.getObjectsInterpretation().processBackgroundAsObject());
        long count = 0L;
        while (scanner.nextBoundary()) {
            scanner.scanAndProcess();
            if (!scanner.needToAnalyseThisBoundary()) continue;
            objectLabelArray.addInt(scanner.currentLabel());
            internalBoundaryFlags.addBit(scanner.internalBoundary());
            for (k = 0; k < parametersArray.length; ++k) {
                parametersArray[k].getStatistics(statisticsArray[k], measurer, this.getPixelSize(), this.secondProjectionValue, this.thirdProjectionValue);
            }
            ++count;
        }
        ScanAndMeasureBoundaries.uploadSimpleOutputs((Executor)this, scanner, (IntArray)objectLabelArray, (BitArray)internalBoundaryFlags);
        ScanAndMeasureBoundariesProjections.logDebug(() -> "Scanned projections of " + scanner.objectCounter() + " boundaries, " + scanner.sideCounter() + " pixel sides for calculating " + parametersArray.length + " parameters " + parameters + " at " + objects);
        for (k = 0; k < parametersArray.length; ++k) {
            ProjectionParameter p = parametersArray[k];
            MutablePNumberArray a = statisticsArray[k];
            int blockLength = p.parameterLength(measurer, this.thirdProjectionValue);
            if (a.length() != count * (long)blockLength) {
                throw new AssertionError((Object)("Number of statistics elements " + a.length() + " mismatches with objects count (" + count + ") * length (" + blockLength + ") for " + p));
            }
            resultStatistics.get((Object)p).setTo((PNumberArray)a, blockLength);
        }
        return ScanAndMeasureBoundaries.getLabels(scanner);
    }

    private static Map<ProjectionParameter, SNumbers> convertMap(Map<String, SNumbers> statistics) {
        LinkedHashMap<ProjectionParameter, SNumbers> result = new LinkedHashMap<ProjectionParameter, SNumbers>();
        statistics.forEach((s, numbers) -> {
            ProjectionParameter parameter = OUTPUT_STATISTICS.get(s);
            if (parameter != null) {
                result.put(parameter, (SNumbers)numbers);
            }
        });
        return result;
    }

    static {
        OUTPUT_STATISTICS.put(OUTPUT_AREA, ProjectionParameter.AREA);
        OUTPUT_STATISTICS.put(OUTPUT_PERIMETER, ProjectionParameter.PERIMETER);
        OUTPUT_STATISTICS.put(OUTPUT_ALL_PROJECTION, ProjectionParameter.ALL_PROJECTIONS);
        OUTPUT_STATISTICS.put(OUTPUT_SELECTED_PROJECTION, ProjectionParameter.SELECTED_PROJECTION);
        OUTPUT_STATISTICS.put(OUTPUT_MEAN_PROJECTION, ProjectionParameter.MEAN_PROJECTION);
        OUTPUT_STATISTICS.put(OUTPUT_MAX_PROJECTION, ProjectionParameter.MAX_PROJECTION);
        OUTPUT_STATISTICS.put(OUTPUT_MIN_PROJECTION, ProjectionParameter.MIN_PROJECTION);
        OUTPUT_STATISTICS.put(OUTPUT_MAX_SIZE_RELATION, ProjectionParameter.MAX_SIZE_RELATION);
        OUTPUT_STATISTICS.put(OUTPUT_MIN_CIRCUMSCRIBED_SQUARE_SIDE, ProjectionParameter.MIN_CIRCUMSCRIBED_SQUARE_SIDE);
        OUTPUT_STATISTICS.put(OUTPUT_SHAPE_FACTOR, ProjectionParameter.SHAPE_FACTOR);
        OUTPUT_STATISTICS.put(OUTPUT_COMPACT_FACTOR, ProjectionParameter.COMPACT_FACTOR);
        OUTPUT_STATISTICS.put(OUTPUT_IRREGULARITY_FACTOR, ProjectionParameter.IRREGULARITY_FACTOR);
        OUTPUT_STATISTICS.put(OUTPUT_NESTING_LEVEL, ProjectionParameter.NESTING_LEVEL);
    }
}

