/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary;

import java.util.ArrayList;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.RectangularFunc;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.multimatrix.MultiMatrix;

public final class NeighbourPixelsCount
extends BitMultiMatrixFilter {
    public static final String OUTPUT_Q = "Q";
    private static final long[][] NEIGHBOUR_SHIFTS_4 = new long[][]{{1L, 0L}, {0L, 1L}, {-1L, 0L}, {0L, -1L}};
    private static final long[][] NEIGHBOUR_SHIFTS_8 = new long[][]{{1L, 0L}, {0L, 1L}, {-1L, 0L}, {0L, -1L}, {1L, 1L}, {-1L, 1L}, {-1L, -1L}, {1L, -1L}};
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;
    private int minNumberOfNeighbours = 0;
    private int maxNumberOfNeighbours = 0;
    private boolean unitPixelsOnly = true;

    public NeighbourPixelsCount() {
        this.addOutputMat(OUTPUT_Q);
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public NeighbourPixelsCount setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)NeighbourPixelsCount.nonNull((Object)connectivityType);
        return this;
    }

    public int getMinNumberOfNeighbours() {
        return this.minNumberOfNeighbours;
    }

    public NeighbourPixelsCount setMinNumberOfNeighbours(int minNumberOfNeighbours) {
        this.minNumberOfNeighbours = minNumberOfNeighbours;
        return this;
    }

    public int getMaxNumberOfNeighbours() {
        return this.maxNumberOfNeighbours;
    }

    public NeighbourPixelsCount setMaxNumberOfNeighbours(int maxNumberOfNeighbours) {
        this.maxNumberOfNeighbours = maxNumberOfNeighbours;
        return this;
    }

    public boolean isUnitPixelsOnly() {
        return this.unitPixelsOnly;
    }

    public NeighbourPixelsCount setUnitPixelsOnly(boolean unitPixelsOnly) {
        this.unitPixelsOnly = unitPixelsOnly;
        return this;
    }

    public Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> bitMatrix) {
        long[][] neighbourShifts = switch (this.connectivityType) {
            case ConnectivityType.STRAIGHT_ONLY -> NEIGHBOUR_SHIFTS_4;
            case ConnectivityType.STRAIGHT_AND_DIAGONAL -> NEIGHBOUR_SHIFTS_8;
            default -> throw new UnsupportedOperationException("Unsuported " + this.connectivityType);
        };
        ArrayList<Object> shifted = new ArrayList<Object>();
        shifted.add(bitMatrix);
        for (long[] shift : neighbourShifts) {
            shifted.add(Matrices.asShifted(bitMatrix, (long[])shift).cast(PArray.class));
        }
        Matrix counter = Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)LinearFunc.getNonweightedInstance((double)0.0, (double)1.0, (int)shifted.size()), IntArray.class, shifted));
        this.getMat(OUTPUT_Q).setTo((MultiMatrix)MultiMatrix.of2DMono((Matrix)this.reduce(counter)));
        Matrix result = Matrices.asFuncMatrix((Func)RectangularFunc.getInstance((double)(this.minNumberOfNeighbours + 1), (double)(this.maxNumberOfNeighbours + 1), (double)1.0, (double)0.0), BitArray.class, (Matrix)counter);
        return this.unitPixelsOnly ? Matrices.asFuncMatrix((Func)Func.MIN, BitArray.class, (Matrix)result, bitMatrix) : result;
    }

    protected boolean zeroExtending() {
        return true;
    }
}

