/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToNumbers;
import net.algart.executors.modules.cv.matrices.drawing.DrawLine;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.executors.modules.cv.matrices.objects.binary.NearestPixelFinder;
import net.algart.math.IRange;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class NearestMatrixPixels
extends MultiMatrixToNumbers {
    private static final int MULTITHREADING_POSITIONS_BLOCK_LENGTH = 128;
    public static final String INPUT_MASK = "mask";
    public static final String INPUT_POSITIONS = "positions";
    public static final String OUTPUT_NEAREST_PIXELS = "nearest_pixels";
    public static final String OUTPUT_NUMBERS_OF_NEAREST = "numbers_of_nearest";
    public static final String OUTPUT_LINES_TO_NEAREST = "lines_to_nearest";
    private int maxApertureSize = 10;
    private int neighbourhoodSizeForNearest = 3;
    private int maxNumberOfNeighbours = 1;
    private boolean invertSourceMask = false;
    private boolean skipPositionsAtMaks = true;
    private boolean returnPairsOfThisAndNearestPixel = true;
    private int drawingLinesThickness = 1;
    private Color drawingLinesColor = Color.WHITE;
    private boolean convertMonoToColorForDrawingLines = false;
    private boolean visibleLinesToNearest = false;

    public NearestMatrixPixels() {
        this.setDefaultInputMat(INPUT_MASK);
        this.setDefaultOutputNumbers(OUTPUT_NEAREST_PIXELS);
        this.addOutputNumbers(OUTPUT_NUMBERS_OF_NEAREST);
        this.addOutputMat(OUTPUT_LINES_TO_NEAREST);
    }

    public int getMaxApertureSize() {
        return this.maxApertureSize;
    }

    public NearestMatrixPixels setMaxApertureSize(int maxApertureSize) {
        this.maxApertureSize = NearestMatrixPixels.positive((int)maxApertureSize);
        return this;
    }

    public int getNeighbourhoodSizeForNearest() {
        return this.neighbourhoodSizeForNearest;
    }

    public NearestMatrixPixels setNeighbourhoodSizeForNearest(int neighbourhoodSizeForNearest) {
        this.neighbourhoodSizeForNearest = NearestMatrixPixels.positive((int)neighbourhoodSizeForNearest);
        return this;
    }

    public int getMaxNumberOfNeighbours() {
        return this.maxNumberOfNeighbours;
    }

    public NearestMatrixPixels setMaxNumberOfNeighbours(int maxNumberOfNeighbours) {
        this.maxNumberOfNeighbours = NearestMatrixPixels.positive((int)maxNumberOfNeighbours);
        return this;
    }

    public boolean isInvertSourceMask() {
        return this.invertSourceMask;
    }

    public NearestMatrixPixels setInvertSourceMask(boolean invertSourceMask) {
        this.invertSourceMask = invertSourceMask;
        return this;
    }

    public boolean isSkipPositionsAtMaks() {
        return this.skipPositionsAtMaks;
    }

    public NearestMatrixPixels setSkipPositionsAtMaks(boolean skipPositionsAtMaks) {
        this.skipPositionsAtMaks = skipPositionsAtMaks;
        return this;
    }

    public boolean isReturnPairsOfThisAndNearestPixel() {
        return this.returnPairsOfThisAndNearestPixel;
    }

    public NearestMatrixPixels setReturnPairsOfThisAndNearestPixel(boolean returnPairsOfThisAndNearestPixel) {
        this.returnPairsOfThisAndNearestPixel = returnPairsOfThisAndNearestPixel;
        return this;
    }

    public int getDrawingLinesThickness() {
        return this.drawingLinesThickness;
    }

    public NearestMatrixPixels setDrawingLinesThickness(int drawingLinesThickness) {
        this.drawingLinesThickness = NearestMatrixPixels.positive((int)drawingLinesThickness);
        return this;
    }

    public Color getDrawingLinesColor() {
        return this.drawingLinesColor;
    }

    public NearestMatrixPixels setDrawingLinesColor(Color drawingLinesColor) {
        this.drawingLinesColor = (Color)NearestMatrixPixels.nonNull((Object)drawingLinesColor);
        return this;
    }

    public boolean isConvertMonoToColorForDrawingLines() {
        return this.convertMonoToColorForDrawingLines;
    }

    public NearestMatrixPixels setConvertMonoToColorForDrawingLines(boolean convertMonoToColorForDrawingLines) {
        this.convertMonoToColorForDrawingLines = convertMonoToColorForDrawingLines;
        return this;
    }

    public boolean isVisibleLinesToNearest() {
        return this.visibleLinesToNearest;
    }

    public NearestMatrixPixels setVisibleLinesToNearest(boolean visibleLinesToNearest) {
        this.visibleLinesToNearest = visibleLinesToNearest;
        return this;
    }

    public SNumbers analyse(MultiMatrix sourceMask) {
        Objects.requireNonNull(sourceMask, "Null source mask");
        return this.analyse(sourceMask.asMultiMatrix2D(), this.getInputNumbers(INPUT_POSITIONS));
    }

    public SNumbers analyse(MultiMatrix2D sourceMask, SNumbers positions) {
        positions.requireBlockLength(2, INPUT_POSITIONS);
        int[] positionsArray = positions.toIntArray();
        long t1 = System.nanoTime();
        Matrix mask = this.invertSourceMask ? sourceMask.zeroRGBMatrix() : sourceMask.nonZeroRGBMatrix();
        SortedRound2DAperture maxAperture = SortedRound2DAperture.getCircle(this.maxApertureSize, sourceMask.dimX());
        SortedRound2DAperture neighbourhoodForNearest = SortedRound2DAperture.getCircle(this.neighbourhoodSizeForNearest, sourceMask.dimX());
        NearestPixelFinder finder = new NearestPixelFinder((Matrix<? extends BitArray>)mask, maxAperture, neighbourhoodForNearest).setMaxNumberOfNeighbours(this.maxNumberOfNeighbours).setSkipPositionsAtMaks(this.skipPositionsAtMaks);
        long t2 = System.nanoTime();
        MutableIntArray nearestXY = Arrays.SMM.newEmptyIntArray();
        int n = positions.n();
        int[] numbersOfNearest = new int[n];
        if (n > 0) {
            if (Arrays.SystemSettings.cpuCount() == 1) {
                nearestXY = NearestMatrixPixels.findNearestInRange(finder, positionsArray, IRange.valueOf((long)0L, (long)(n - 1)), numbersOfNearest);
            } else {
                ArrayList<IRange> ranges = new ArrayList<IRange>();
                int blockLength = Math.max(1, Math.min(128, n / Runtime.getRuntime().availableProcessors()));
                for (int i = 0; i < n; i += blockLength) {
                    ranges.add(IRange.valueOf((long)i, (long)(Math.min(i + blockLength, n) - 1)));
                }
                List<MutableIntArray> results = ranges.parallelStream().map(range -> NearestMatrixPixels.findNearestInRange(finder, positionsArray, range, numbersOfNearest)).toList();
                for (IntArray intArray : results) {
                    nearestXY.append((Array)intArray);
                }
            }
        }
        long t3 = System.nanoTime();
        boolean outputLines = this.isOutputNecessary(OUTPUT_LINES_TO_NEAREST);
        int[] resultPositions = null;
        if (outputLines || this.returnPairsOfThisAndNearestPixel) {
            SNumbers.checkDimensions((long)(nearestXY.length() / 2L), (long)4L);
            int[] nArray = new int[2 * (int)nearestXY.length()];
            int disp = 0;
            int p = 0;
            for (int i = 0; i < n; ++i) {
                int x = positionsArray[2 * i];
                int y = positionsArray[2 * i + 1];
                int m = numbersOfNearest[i];
                for (int j = 0; j < m; ++j) {
                    nArray[disp++] = x;
                    nArray[disp++] = y;
                    nArray[disp++] = nearestXY.getInt((long)p++);
                    nArray[disp++] = nearestXY.getInt((long)p++);
                }
            }
            if (outputLines) {
                try (DrawLine drawLine = new DrawLine();){
                    drawLine.setAntialiasing(false);
                    drawLine.setThickness(this.drawingLinesThickness);
                    drawLine.setConvertMonoToColor(this.convertMonoToColorForDrawingLines);
                    drawLine.setColor(this.drawingLinesColor);
                    drawLine.putNumbers(INPUT_POSITIONS, nArray, 4);
                    drawLine.putMat(DEFAULT_INPUT_PORT, SMat.of((MultiMatrix)sourceMask));
                    drawLine.process();
                    SMat mat = drawLine.getMat();
                    if (this.convertMonoToColorForDrawingLines) {
                        this.getMat(OUTPUT_LINES_TO_NEAREST).setTo(mat.clone());
                    } else {
                        this.getMat(OUTPUT_LINES_TO_NEAREST).setTo((MultiMatrix)mat.toMultiMatrix2D().nonZeroRGB());
                    }
                }
            }
            if (this.returnPairsOfThisAndNearestPixel) {
                resultPositions = nArray;
            }
        }
        if (resultPositions == null) {
            resultPositions = nearestXY.toJavaArray();
        }
        this.getNumbers(OUTPUT_NUMBERS_OF_NEAREST).setTo(numbersOfNearest, 1);
        SNumbers sNumbers = SNumbers.ofArray((Object)resultPositions, (int)(this.returnPairsOfThisAndNearestPixel ? 4 : 2));
        long t4 = System.nanoTime();
        NearestMatrixPixels.logDebug(() -> String.format(Locale.US, "Nearest matrix pixels for %d points at %s, aperture size %d (%d points): %.3f ms = %.3f preparing, %.3f search, %.3f making results", n, sourceMask, this.maxApertureSize, maxAperture.count(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
        return sNumbers;
    }

    public String visibleOutputPortName() {
        return this.visibleLinesToNearest ? OUTPUT_LINES_TO_NEAREST : OUTPUT_NEAREST_PIXELS;
    }

    private static MutableIntArray findNearestInRange(NearestPixelFinder finder, int[] positions, IRange range, int[] resultNumbersOfNearest) {
        MutableIntArray result = Arrays.SMM.newEmptyIntArray();
        int max = (int)range.max();
        for (int k = (int)range.min(); k <= max; ++k) {
            int x = positions[2 * k];
            int y = positions[2 * k + 1];
            resultNumbersOfNearest[k] = finder.findNearest(x, y, result);
        }
        return result;
    }
}

