/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.Matrix;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.numbers.misc.InvertTable;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class TableTranslate
extends MultiMatrix2DFilter {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_TABLE = "table";
    public static final String OUTPUT_LABELS = "labels";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private ResultElementType resultElementType = ResultElementType.INT;
    private Double replacementForNotExisting = null;
    private boolean invertTable = false;

    public TableTranslate() {
        this.setDefaultInputMat("labels");
        this.addInputNumbers(INPUT_TABLE);
        this.setDefaultOutputMat("labels");
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public TableTranslate setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)TableTranslate.nonNull((Object)indexingBase);
        return this;
    }

    public ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public TableTranslate setResultElementType(ResultElementType resultElementType) {
        this.resultElementType = resultElementType;
        return this;
    }

    public Double replacementForNotExisting() {
        return this.replacementForNotExisting;
    }

    public TableTranslate setReplacementForNotExisting(Double replacementForNotExisting) {
        this.replacementForNotExisting = replacementForNotExisting;
        return this;
    }

    public boolean isInvertTable() {
        return this.invertTable;
    }

    public TableTranslate setInvertTable(boolean invertTable) {
        this.invertTable = invertTable;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix) {
        SNumbers table = this.getInputNumbers(INPUT_TABLE);
        return switch (this.resultElementType) {
            default -> throw new IncompatibleClassChangeError();
            case ResultElementType.INT -> this.process(labelsMatrix, table.toIntArray());
            case ResultElementType.FLOAT -> this.process(labelsMatrix, table.toFloatArray());
        };
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix, int[] translationTable) {
        int[] table;
        Objects.requireNonNull(labelsMatrix, "Null labels");
        Objects.requireNonNull(translationTable, "Null translation table");
        int[] labels = labelsMatrix.channel(0).toInt();
        int[] nArray = table = this.invertTable ? InvertTable.invert((int[])translationTable, (int)this.indexingBase.start) : translationTable;
        if (this.replacementForNotExisting == null) {
            IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)labels.length);
                for (i = block << 8; i < to; ++i) {
                    int label = labels[i] - this.indexingBase.start;
                    if (label < 0 || label >= table.length) continue;
                    labels[i] = table[label];
                }
            });
        } else {
            int replacement = (int)this.replacementForNotExisting.doubleValue();
            IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)labels.length);
                for (i = block << 8; i < to; ++i) {
                    int label = labels[i] - this.indexingBase.start;
                    labels[i] = label >= 0 && label < table.length ? table[label] : replacement;
                }
            });
        }
        return MultiMatrix.of2DMono((Matrix)Matrix.as((Object)labels, (long[])labelsMatrix.dimensions()));
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix, float[] translationTable) {
        Objects.requireNonNull(labelsMatrix, "Null labels");
        Objects.requireNonNull(translationTable, "Null translation table");
        if (this.invertTable) {
            throw new IllegalArgumentException("\"Invert table\" mode requires \"int\" result elements, but \"float\" result type is specified");
        }
        int[] labels = labelsMatrix.channel(0).jaInt();
        float[] result = new float[labels.length];
        if (this.replacementForNotExisting == null) {
            IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)labels.length);
                for (i = block << 8; i < to; ++i) {
                    int originalLabel = labels[i];
                    int label = originalLabel - this.indexingBase.start;
                    result[i] = label >= 0 && label < translationTable.length ? translationTable[label] : (float)originalLabel;
                }
            });
        } else {
            float replacement = this.replacementForNotExisting.floatValue();
            IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)labels.length);
                for (i = block << 8; i < to; ++i) {
                    int label = labels[i] - this.indexingBase.start;
                    result[i] = label >= 0 && label < translationTable.length ? translationTable[label] : replacement;
                }
            });
        }
        return MultiMatrix.of2DMono((Matrix)Matrix.as((Object)result, (long[])labelsMatrix.dimensions()));
    }

    public static enum ResultElementType {
        INT(Integer.TYPE),
        FLOAT(Float.TYPE);

        final Class<?> elementType;

        private ResultElementType(Class<?> elementType) {
            this.elementType = elementType;
        }
    }
}

