/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SelectLabelledObjectsByBinaryArray
extends MultiMatrix2DFilter {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_BASE = "base";
    public static final String INPUT_SELECTOR = "selector";
    public static final String OUTPUT_SELECTED = "selected";
    private SelectorInterpretation selectorInterpretation = SelectorInterpretation.SELECT_NON_ZERO;
    private ActionOnBase actionOnBase = ActionOnBase.ADD_SELECTED_TO_BASE;

    public SelectLabelledObjectsByBinaryArray() {
        this.setDefaultInputMat(INPUT_LABELS);
        this.addInputMat(INPUT_BASE);
        this.addInputNumbers(INPUT_SELECTOR);
        this.addOutputMat(OUTPUT_SELECTED);
    }

    public SelectorInterpretation getSelectorInterpretation() {
        return this.selectorInterpretation;
    }

    public void setSelectorInterpretation(SelectorInterpretation selectorInterpretation) {
        this.selectorInterpretation = (SelectorInterpretation)((Object)SelectLabelledObjectsByBinaryArray.nonNull((Object)((Object)selectorInterpretation)));
    }

    public ActionOnBase getActionOnBase() {
        return this.actionOnBase;
    }

    public void setActionOnBase(ActionOnBase actionOnBase) {
        this.actionOnBase = (ActionOnBase)((Object)SelectLabelledObjectsByBinaryArray.nonNull((Object)((Object)actionOnBase)));
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix) {
        MultiMatrix2D base = this.getInputMat(INPUT_BASE, true).toMultiMatrix2D();
        SNumbers selectors = this.getInputNumbers(INPUT_SELECTOR);
        return this.process(labelsMatrix, base, selectors);
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix, MultiMatrix2D baseMatrix, SNumbers selectors) {
        Objects.requireNonNull(labelsMatrix, "Null labels");
        Objects.requireNonNull(selectors, "Null selectors");
        labelsMatrix.checkDimensionEquality((MultiMatrix)baseMatrix, INPUT_LABELS, INPUT_BASE);
        byte[] selectorsArray = selectors.column(0).toByteArray();
        int[] labels = labelsMatrix.channel(0).toInt();
        boolean[] selectedArray = new boolean[labels.length];
        switch (this.selectorInterpretation) {
            case SELECT_NON_ZERO: {
                int label;
                int i;
                for (i = 0; i < labels.length; ++i) {
                    label = labels[i];
                    if (label <= 0 || label > selectorsArray.length) continue;
                    selectedArray[i] = selectorsArray[label - 1] != 0;
                }
                break;
            }
            case SELECT_ZERO: {
                int label;
                int i;
                for (i = 0; i < labels.length; ++i) {
                    label = labels[i];
                    if (label <= 0 || label > selectorsArray.length) continue;
                    selectedArray[i] = selectorsArray[label - 1] == 0;
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown " + this.selectorInterpretation));
            }
        }
        Matrix selected = Arrays.SMM.newBitMatrix(labelsMatrix.dimensions());
        ((UpdatableBitArray)selected.array()).setData(0L, (Object)selectedArray);
        MultiMatrix2D selectedMatrix = MultiMatrix.of2DMono((Matrix)selected);
        this.getMat(OUTPUT_SELECTED).setTo((MultiMatrix)selectedMatrix);
        if (baseMatrix == null) {
            return this.actionOnBase == ActionOnBase.REMOVE_SELECTED_FROM_BASE ? selectedMatrix.zeroAllChannels() : selectedMatrix;
        }
        return this.actionOnBase == ActionOnBase.REMOVE_SELECTED_FROM_BASE ? baseMatrix.min(selectedMatrix.zeroAllChannels()) : baseMatrix.max(selectedMatrix);
    }

    public static enum SelectorInterpretation {
        SELECT_NON_ZERO,
        SELECT_ZERO;

    }

    public static enum ActionOnBase {
        ADD_SELECTED_TO_BASE,
        REMOVE_SELECTED_FROM_BASE;

    }
}

