/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannel2DFilter;
import net.algart.executors.modules.cv.matrices.drawing.PositionsAndColors;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;

public final class DrawRectangle
extends MultiMatrixChannel2DFilter {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_COLORS = "colors";
    private String color = "#FFFFFF";
    private boolean percents = false;
    private double left = 0.0;
    private double top = 0.0;
    private double right = 0.0;
    private double bottom = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private int thickness = 0;
    private boolean clearSource = false;

    public DrawRectangle() {
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_COLORS);
    }

    public String getColor() {
        return this.color;
    }

    public DrawRectangle setColor(String color) {
        this.color = (String)DrawRectangle.nonNull((Object)color);
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawRectangle setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getLeft() {
        return this.left;
    }

    public DrawRectangle setLeft(double left) {
        this.left = left;
        return this;
    }

    public double getTop() {
        return this.top;
    }

    public DrawRectangle setTop(double top) {
        this.top = top;
        return this;
    }

    public double getRight() {
        return this.right;
    }

    public DrawRectangle setRight(double right) {
        this.right = right;
        return this;
    }

    public double getBottom() {
        return this.bottom;
    }

    public DrawRectangle setBottom(double bottom) {
        this.bottom = bottom;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public DrawRectangle setWidth(double width) {
        this.width = DrawRectangle.nonNegative((double)width);
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public DrawRectangle setHeight(double height) {
        this.height = DrawRectangle.nonNegative((double)height);
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public DrawRectangle setThickness(int thickness) {
        this.thickness = DrawRectangle.nonNegative((int)thickness);
        return this;
    }

    public boolean isClearSource() {
        return this.clearSource;
    }

    public DrawRectangle setClearSource(boolean clearSource) {
        this.clearSource = clearSource;
        return this;
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        Matrix clone;
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double maxPossibleValue = ((PArray)m.array()).maxPossibleValue(1.0);
        double defaultValue = this.colorChannel(this.color, maxPossibleValue);
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, defaultValue);
        Matrix matrix = clone = this.clearSource ? Arrays.SMM.newMatrix(UpdatablePArray.class, m) : Matrices.matrix((Array)((PArray)m.array()).updatableClone((MemoryModel)Arrays.SMM), (long[])m.dimensions());
        if (this.clearSource && this.currentChannel() == 3) {
            ((UpdatablePArray)clone.array()).fill(((UpdatablePArray)clone.array()).maxPossibleValue(1.0));
        }
        for (int k = 0; k < positionsAndColors.n; ++k) {
            for (IRectangularArea r : this.filledRectangles(m.dimX(), m.dimY(), positionsAndColors.xy, positionsAndColors.xyBlockLength, k)) {
                Matrices.Hyperparallelepiped region = Matrices.Region.getRectangle2D((IRange)r.range(0), (IRange)r.range(1));
                double value = positionsAndColors.colorValue(k, this.currentChannel(), maxPossibleValue);
                if (clone.array() instanceof PFixedArray) {
                    value = Math.max(value, 0.0);
                    value = Math.min(value, maxPossibleValue);
                }
                Matrices.fillRegion((Matrix)clone, (Matrices.Region)region, (Object)value);
            }
        }
        return clone;
    }

    private Collection<IRectangularArea> filledRectangles(long dimX, long dimY, double[] positions, int blockLength, int index) {
        if (dimX <= 0L || dimY <= 0L) {
            return Collections.emptyList();
        }
        long x1 = Math.round(this.percents ? this.left / 100.0 * (double)(dimX - 1L) : this.left);
        long x2 = Math.round(this.percents ? this.right / 100.0 * (double)(dimX - 1L) : this.right);
        long y1 = Math.round(this.percents ? this.top / 100.0 * (double)(dimY - 1L) : this.top);
        long y2 = Math.round(this.percents ? this.bottom / 100.0 * (double)(dimY - 1L) : this.bottom);
        long sizeX = Math.round(this.percents ? this.width / 100.0 * (double)dimX : this.width);
        long sizeY = Math.round(this.percents ? this.height / 100.0 * (double)dimY : this.height);
        if (x1 < 0L) {
            x1 += dimX;
        }
        if (x2 < 0L) {
            x2 += dimX;
        }
        if (y1 < 0L) {
            y1 += dimY;
        }
        if (y2 < 0L) {
            y2 += dimY;
        }
        if (sizeX > 0L) {
            x2 = x1 + sizeX - 1L;
        }
        if (sizeY > 0L) {
            y2 = y1 + sizeY - 1L;
        }
        sizeX = x2 - x1 + 1L;
        sizeY = y2 - y1 + 1L;
        if (positions != null && positions.length > 0) {
            double x = positions[index * blockLength];
            double y = positions[index * blockLength + 1];
            double pixelCenterSizeX = sizeX - 1L;
            double pixelCenterSizeY = sizeY - 1L;
            if (blockLength >= 4) {
                pixelCenterSizeX = Math.max(0.0, positions[index * blockLength + 2] - 1.0);
                pixelCenterSizeY = Math.max(0.0, positions[index * blockLength + 3] - 1.0);
            } else if (sizeX <= 0L || sizeY <= 0L) {
                return Collections.emptyList();
            }
            x1 = Math.round(x - 0.5 * pixelCenterSizeX);
            y1 = Math.round(y - 0.5 * pixelCenterSizeY);
            x2 = Math.round(x + 0.5 * pixelCenterSizeX);
            y2 = Math.round(y + 0.5 * pixelCenterSizeY);
            sizeX = x2 - x1 + 1L;
            sizeY = y2 - y1 + 1L;
        }
        if (sizeX <= 0L || sizeY <= 0L) {
            return Collections.emptyList();
        }
        LinkedList<IRectangularArea> rectangles = new LinkedList<IRectangularArea>();
        rectangles.add(IRectangularArea.valueOf((long)x1, (long)y1, (long)x2, (long)y2));
        if (this.thickness > 0 && (long)(2 * this.thickness) < sizeX && (long)(2 * this.thickness) < sizeY) {
            IRectangularArea.subtractCollection(rectangles, (IRectangularArea[])new IRectangularArea[]{IRectangularArea.valueOf((long)(x1 + (long)this.thickness), (long)(y1 + (long)this.thickness), (long)(x2 - (long)this.thickness), (long)(y2 - (long)this.thickness))});
        }
        return rectangles;
    }
}

