/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import net.algart.executors.modules.core.common.awt.AWTDrawer;

public final class DrawArrow
extends AWTDrawer {
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double x2 = 0.0;
    private double y2 = 0.0;
    private double thickness = 1.0;
    private double arrowLength = 20.0;
    private double arrowWidth = 5.0;

    public double getX1() {
        return this.x1;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getY1() {
        return this.y1;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getY2() {
        return this.y2;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = DrawArrow.positive((double)thickness);
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double arrowLength) {
        this.arrowLength = DrawArrow.positive((double)arrowLength);
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double arrowWidth) {
        this.arrowWidth = DrawArrow.positive((double)arrowWidth);
    }

    public void process(Graphics2D g, int dimX, int dimY) {
        DrawArrow.drawArrowLine(g, (int)Math.round(this.x1), (int)Math.round(this.y1), (int)Math.round(this.x2), (int)Math.round(this.y2), this.thickness, this.arrowLength, this.arrowWidth);
    }

    public static void drawArrowLine(Graphics2D graphics, int x1, int y1, int x2, int y2, double thickness, double arrowLength, double arrowWidth) {
        double xm;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        double xn = xm = length - arrowLength;
        double ym = arrowWidth;
        double yn = -arrowWidth;
        double sin = (double)dy / length;
        double cos = (double)dx / length;
        double x = xm * cos - ym * sin + (double)x1;
        ym = xm * sin + ym * cos + (double)y1;
        xm = x;
        x = xn * cos - yn * sin + (double)x1;
        yn = xn * sin + yn * cos + (double)y1;
        xn = x;
        int[] xpoints = new int[]{x2, (int)xm, (int)xn};
        int[] ypoints = new int[]{y2, (int)ym, (int)yn};
        graphics.setStroke(new BasicStroke((float)thickness));
        graphics.drawLine(x1, y1, (int)((xm + xn) / 2.0), (int)((ym + yn) / 2.0));
        graphics.setStroke(new BasicStroke());
        graphics.drawLine(x1, y1, x2, y2);
        graphics.fillPolygon(xpoints, ypoints, 3);
    }
}

