/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.util.ArrayList;
import org.bytedeco.opencv.global.opencv_core;

public final class MultithreadingUseOpenCLCallsTest {
    public static void main(String[] args) {
        int numberOfTests = 150;
        for (int test = 1; test <= 150; ++test) {
            System.out.printf("%nTest #%d/%d...%n", test, 150);
            ArrayList<SimpleExecutor> executors = new ArrayList<SimpleExecutor>();
            for (int k = 1; k <= 5; ++k) {
                executors.add(new SimpleExecutor(k));
            }
            executors.parallelStream().forEach(SimpleExecutor::execute);
        }
    }

    static class SimpleExecutor {
        final int index;

        public SimpleExecutor(int index) {
            this.index = index;
        }

        public synchronized void execute() {
            boolean haveOpenCL = opencv_core.haveOpenCL();
            boolean useOpenCL = opencv_core.useOpenCL();
            System.out.println("Executor " + this.index + ": " + (useOpenCL != haveOpenCL ? "!!! STRANGE SITUATION! " : "") + "haveOpenCL: " + haveOpenCL + "; useOpenCL: " + useOpenCL);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

