/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.executors.modules.cv.matrices.objects.binary.components.ConnectedComponentScanning;
import net.algart.math.functions.Func;
import net.algart.matrices.scanning.ConnectedObjectScanner;
import net.algart.multimatrix.MultiMatrix2D;

public final class FindConnectedWithMask
extends ConnectedComponentScanning {
    public static final String INPUT_OBJECTS = "objects";
    public static final String INPUT_MASK = "mask";
    private RetainOrRemoveMode mode = RetainOrRemoveMode.RETAIN;
    private boolean invertMask = false;
    private boolean includeMaskInRetained = false;

    public FindConnectedWithMask() {
        super(INPUT_OBJECTS, INPUT_MASK);
    }

    public RetainOrRemoveMode getMode() {
        return this.mode;
    }

    public void setMode(RetainOrRemoveMode mode) {
        this.mode = (RetainOrRemoveMode)((Object)FindConnectedWithMask.nonNull((Object)((Object)mode)));
    }

    public boolean isInvertMask() {
        return this.invertMask;
    }

    public void setInvertMask(boolean invertMask) {
        this.invertMask = invertMask;
    }

    public boolean isIncludeMaskInRetained() {
        return this.includeMaskInRetained;
    }

    public void setIncludeMaskInRetained(boolean includeMaskInRetained) {
        this.includeMaskInRetained = includeMaskInRetained;
    }

    protected Matrix<? extends PArray> processMatrix(List<Matrix<? extends UpdatablePArray>> bitMatrices, List<MultiMatrix2D> sources) {
        Matrix objectsClone;
        Matrix objects = FindConnectedWithMask.asBit(bitMatrices.get(0));
        Matrix mask = FindConnectedWithMask.asBit(bitMatrices.get(1));
        Matrix matrix = objectsClone = this.mode == RetainOrRemoveMode.RETAIN ? FindConnectedWithMask.cloneBit((Matrix)objects) : null;
        if (this.invertMask) {
            Matrices.applyFunc(null, (Func)Func.REVERSE, (Matrix)mask, (Matrix)mask);
            this.clearBorderInExtended(mask);
        }
        Matrix maskClone = this.includeMaskInRetained ? FindConnectedWithMask.cloneBit((Matrix)mask) : null;
        ConnectedObjectScanner scanner = this.connectedObjectScanner((Matrix<? extends UpdatableBitArray>)mask);
        long pixelCounter = scanner.clearAllConnected(null, objects);
        FindConnectedWithMask.logDebug(() -> "FindConnectedWithMask: " + pixelCounter + " pixels scanned for " + objects);
        if (this.mode == RetainOrRemoveMode.RETAIN) {
            Matrices.applyFunc(null, (Func)Func.ABS_DIFF, (Matrix)objects, (Matrix)objects, (Matrix)objectsClone);
            if (this.includeMaskInRetained) {
                assert (maskClone != null);
                Matrices.applyFunc(null, (Func)Func.MAX, (Matrix)objects, (Matrix)objects, (Matrix)maskClone);
            }
        }
        return objects;
    }
}

