/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Arrays;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.math.IRectangularArea;

public final class ReviveContourContainingRectangles
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_CONTOURS = "contours";
    public static final String OUTPUT_CHANGED = "changed";
    public static final String OUTPUT_WERE_INCORRECT = "were_incorrect";
    private boolean throwExceptionIfChanged = false;

    public ReviveContourContainingRectangles() {
        this.setDefaultInputNumbers("contours");
        this.setDefaultOutputNumbers("contours");
        this.addOutputScalar(OUTPUT_CHANGED);
        this.addOutputScalar(OUTPUT_WERE_INCORRECT);
    }

    public boolean isThrowExceptionIfChanged() {
        return this.throwExceptionIfChanged;
    }

    public ReviveContourContainingRectangles setThrowExceptionIfChanged(boolean throwExceptionIfChanged) {
        this.throwExceptionIfChanged = throwExceptionIfChanged;
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        int[] serializedContours = source.toIntArray();
        Contours contours = Contours.deserialize((int[])serializedContours);
        Contours result = Contours.newInstance();
        ContourHeader header = new ContourHeader();
        ContourHeader correctedHeader = new ContourHeader();
        boolean someRectangleWasIncorrect = false;
        boolean someRectangleWasChanged = false;
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            contours.getHeader(header, k);
            IRectangularArea previousRectangle = header.containingRectangle();
            header.removeContainingRectangle();
            result.addContour(header, contours.getContour(k));
            IRectangularArea correctedRectangle = result.getHeader(correctedHeader, k).containingRectangle();
            if (previousRectangle.equals((Object)correctedRectangle)) continue;
            someRectangleWasChanged = true;
            if (previousRectangle.contains(correctedRectangle)) continue;
            someRectangleWasIncorrect = true;
        }
        SNumbers serializedResult = SNumbers.of((Contours)result);
        if (!someRectangleWasChanged && !Arrays.equals(serializedContours, (int[])serializedResult.arrayReference())) {
            throw new AssertionError((Object)"Rectangles were not changed, but serialized form is another!");
        }
        this.getScalar(OUTPUT_CHANGED).setTo(someRectangleWasChanged);
        this.getScalar(OUTPUT_WERE_INCORRECT).setTo(someRectangleWasIncorrect);
        if (this.throwExceptionIfChanged && someRectangleWasChanged) {
            throw new IllegalArgumentException("Some containined rectangles were changed; probably the contour array was damaged");
        }
        return serializedResult;
    }
}

