/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.stream.IntStream;
import net.algart.arrays.TooLargeArrayException;
import net.algart.contours.ContourJoiner;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.MeasureContours;
import net.algart.math.IRectangularArea;

public final class JoinContours
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_JOINING_MAP = "joining_map";
    public static final String OUTPUT_CONTOURS = "contours";
    public static final String OUTPUT_CONTAINING_ALL_RECTANGLE = "containing_all_rectangle";
    private ContourJoiner.JoiningOrder joiningOrder = ContourJoiner.JoiningOrder.UNORDERED;
    private Integer gridStepLog = null;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private Integer defaultJoinedLabel = null;
    private boolean automaticallyPackResultContours = true;
    private int measuringTimingLevel = 0;

    public JoinContours() {
        this.setDefaultInputNumbers("contours");
        this.addInputNumbers(INPUT_JOINING_MAP);
        this.setDefaultOutputNumbers("contours");
        this.addOutputNumbers("object_label");
        this.addOutputNumbers("internal_boundary");
        this.addOutputNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE);
        this.addOutputScalar("number_of_objects");
    }

    public ContourJoiner.JoiningOrder getJoiningOrder() {
        return this.joiningOrder;
    }

    public JoinContours setJoiningOrder(ContourJoiner.JoiningOrder joiningOrder) {
        this.joiningOrder = joiningOrder;
        return this;
    }

    public Integer getGridStepLog() {
        return this.gridStepLog;
    }

    public JoinContours setGridStepLog(Integer gridStepLog) {
        this.gridStepLog = gridStepLog == null ? null : Integer.valueOf(JoinContours.nonNegative((int)gridStepLog));
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public JoinContours setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)JoinContours.nonNull((Object)indexingBase);
        return this;
    }

    public Integer getDefaultJoinedLabel() {
        return this.defaultJoinedLabel;
    }

    public JoinContours setDefaultJoinedLabel(Integer defaultJoinedLabel) {
        this.defaultJoinedLabel = defaultJoinedLabel;
        return this;
    }

    public JoinContours setDefaultJoinedLabel(String defaultJoinedLabel) {
        return this.setDefaultJoinedLabel(JoinContours.intOrNull((String)defaultJoinedLabel));
    }

    public boolean isAutomaticallyPackResultContours() {
        return this.automaticallyPackResultContours;
    }

    public JoinContours setAutomaticallyPackResultContours(boolean automaticallyPackResultContours) {
        this.automaticallyPackResultContours = automaticallyPackResultContours;
        return this;
    }

    public int getMeasuringTimingLevel() {
        return this.measuringTimingLevel;
    }

    public JoinContours setMeasuringTimingLevel(int measuringTimingLevel) {
        this.measuringTimingLevel = JoinContours.nonNegative((int)measuringTimingLevel);
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        IRectangularArea containingRectangle;
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        int[] joinedLabelsMap = this.joiningMap();
        if (joinedLabelsMap == null && this.defaultJoinedLabel == null) {
            throw new IllegalArgumentException("The port \"joining_map\" has no initialized data; in this case, you must specify some non-empty default joined label");
        }
        ContourJoiner contourJoiner = this.defaultJoinedLabel == null ? ContourJoiner.newInstance((Contours)contours, (Integer)this.gridStepLog, (int[])joinedLabelsMap) : ContourJoiner.newInstance((Contours)contours, (Integer)this.gridStepLog, (int[])joinedLabelsMap, (int)this.defaultJoinedLabel);
        contourJoiner.setJoiningOrder(this.joiningOrder);
        contourJoiner.setPackResultContours(this.automaticallyPackResultContours);
        contourJoiner.setInterrupter(() -> ((JoinContours)this).isInterrupted());
        if (LOGGABLE_DEBUG) {
            contourJoiner.setMeasureTimingLevel(this.measuringTimingLevel);
        }
        Contours result = contourJoiner.joinContours();
        JoinContours.logDebug(() -> ((ContourJoiner)contourJoiner).timingInfo());
        this.getNumbers("object_label").setTo(result.getAllObjectLabels(), 1);
        this.getNumbers("internal_boundary").setTo(MeasureContours.booleansToBytes(result.getAllInternalContour()), 1);
        if (this.isOutputNecessary(OUTPUT_CONTAINING_ALL_RECTANGLE) && (containingRectangle = contourJoiner.containingRectangle()) != null) {
            this.getNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE).setTo(containingRectangle);
        }
        this.getScalar("number_of_objects").setTo(result.numberOfContours());
        return SNumbers.of((Contours)result);
    }

    private int[] joiningMap() {
        int[] map = this.getInputNumbers(INPUT_JOINING_MAP, true).toIntArray();
        if (map == null) {
            return null;
        }
        int base = this.indexingBase.start;
        if (base == 0) {
            return map;
        }
        assert (base > 0);
        if ((long)map.length + (long)base > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large joining map: > " + (Integer.MAX_VALUE - base));
        }
        int[] result = new int[map.length + base];
        for (int reserved = 0; reserved < base; ++reserved) {
            result[reserved] = reserved;
        }
        IntStream.range(0, map.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)map.length);
            for (i = block << 8; i < to; ++i) {
                int label = map[i];
                if (label < base) {
                    throw new IllegalArgumentException("Objects in contours have labels, less than indexing base: " + label + " < " + base);
                }
                result[base + i] = label;
            }
        });
        return result;
    }
}

