/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.List;
import net.algart.arrays.Array;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixOperationWithRequiredResult;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix2D;

public final class FilterLabelledObjectsByIntersectionWithMask
extends BitMultiMatrixOperationWithRequiredResult {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_MASK = "mask";
    private RetainOrRemoveMode mode = RetainOrRemoveMode.RETAIN;
    private AreaInterpretation areaInterpretation = AreaInterpretation.NUMBER_OF_PIXELS;
    private double minAreaAtMask = 0.0;
    private boolean invertMask = false;
    private int fillerForClearedAreas = 0;

    public FilterLabelledObjectsByIntersectionWithMask() {
        super(new String[]{INPUT_LABELS, INPUT_MASK});
    }

    public RetainOrRemoveMode getMode() {
        return this.mode;
    }

    public FilterLabelledObjectsByIntersectionWithMask setMode(RetainOrRemoveMode mode) {
        this.mode = (RetainOrRemoveMode)((Object)FilterLabelledObjectsByIntersectionWithMask.nonNull((Object)((Object)mode)));
        return this;
    }

    public AreaInterpretation getAreaInterpretation() {
        return this.areaInterpretation;
    }

    public FilterLabelledObjectsByIntersectionWithMask setAreaInterpretation(AreaInterpretation areaInterpretation) {
        this.areaInterpretation = (AreaInterpretation)((Object)FilterLabelledObjectsByIntersectionWithMask.nonNull((Object)((Object)areaInterpretation)));
        return this;
    }

    public double getMinAreaAtMask() {
        return this.minAreaAtMask;
    }

    public FilterLabelledObjectsByIntersectionWithMask setMinAreaAtMask(double minAreaAtMask) {
        this.minAreaAtMask = FilterLabelledObjectsByIntersectionWithMask.nonNegative((double)minAreaAtMask);
        return this;
    }

    public boolean isInvertMask() {
        return this.invertMask;
    }

    public FilterLabelledObjectsByIntersectionWithMask setInvertMask(boolean invertMask) {
        this.invertMask = invertMask;
        return this;
    }

    public int getFillerForClearedAreas() {
        return this.fillerForClearedAreas;
    }

    public FilterLabelledObjectsByIntersectionWithMask setFillerForClearedAreas(int fillerForClearedAreas) {
        this.fillerForClearedAreas = fillerForClearedAreas;
        return this;
    }

    protected Matrix<? extends PArray> processMatrix(List<Matrix<? extends UpdatablePArray>> bitMatrices, List<MultiMatrix2D> sources) {
        int[] histogram;
        boolean absoluteArea;
        int v2;
        MultiMatrix2D labelsMatrix = sources.get(0);
        int[] labelArray = labelsMatrix.channel(0).toInt();
        Matrix mask = FilterLabelledObjectsByIntersectionWithMask.asBit(bitMatrices.get(1));
        if (this.invertMask && mask != null) {
            Matrices.applyFunc(null, (Func)Func.REVERSE, (Matrix)mask, (Matrix)mask);
        }
        int max = 0;
        for (int v2 : labelArray) {
            if (v2 <= max) continue;
            max = v2;
        }
        if (LOGGABLE_DEBUG) {
            FilterLabelledObjectsByIntersectionWithMask.logDebug((String)("Filtering " + max + " labelled objects at " + labelsMatrix));
        }
        boolean bl = absoluteArea = this.areaInterpretation == AreaInterpretation.NUMBER_OF_PIXELS || this.minAreaAtMask == 0.0;
        if (absoluteArea) {
            int minNumberOfPixel = this.minAreaAtMask == 0.0 ? 1 : (int)this.minAreaAtMask;
            histogram = FilterLabelledObjectsByIntersectionWithMask.histogramOfPositive(max, labelArray, mask == null ? null : (BitArray)mask.array());
            for (k = 0; k < histogram.length; ++k) {
                if (histogram[k] >= minNumberOfPixel) continue;
                histogram[k] = -1;
            }
        } else {
            histogram = FilterLabelledObjectsByIntersectionWithMask.histogramOfPositive(max, labelArray, null);
            int[] histogramAtMask = mask == null ? histogram : FilterLabelledObjectsByIntersectionWithMask.histogramOfPositive(max, labelArray, (BitArray)mask.array());
            for (k = 0; k < histogram.length; ++k) {
                if (!((double)histogramAtMask[k] < this.minAreaAtMask * (double)histogram[k])) continue;
                histogram[k] = -1;
            }
        }
        switch (this.mode) {
            case RETAIN: {
                for (int i = 0; i < labelArray.length; ++i) {
                    v2 = labelArray[i];
                    if (v2 <= 0 || histogram[v2 - 1] != -1) continue;
                    labelArray[i] = this.fillerForClearedAreas;
                }
                break;
            }
            case REMOVE: {
                for (int i = 0; i < labelArray.length; ++i) {
                    v2 = labelArray[i];
                    if (v2 <= 0 || histogram[v2 - 1] == -1) continue;
                    labelArray[i] = this.fillerForClearedAreas;
                }
                break;
            }
        }
        return Matrices.matrix((Array)IntArray.as((int[])labelArray), (long[])labelsMatrix.dimensions());
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex == 1;
    }

    protected boolean bitInput(int inputIndex) {
        return inputIndex == 1;
    }

    private static int[] histogramOfPositive(int max, int[] array, BitArray mask) {
        int[] histogram = new int[max];
        if (mask == null) {
            for (int v : array) {
                if (v <= 0) continue;
                int n = v - 1;
                histogram[n] = histogram[n] + 1;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                int v;
                if (!mask.getBit((long)i) || (v = array[i]) <= 0) continue;
                int n = v - 1;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public static enum AreaInterpretation {
        NUMBER_OF_PIXELS,
        FRACTION_OF_OBJECT_0_1;

    }
}

