/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.filtering;

import java.util.Locale;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.matrices.filters3x3.QuickGradientByCross3x3;
import net.algart.multimatrix.MultiMatrix;

public final class SimpleGradient3x3
extends MultiMatrixFilter {
    public MultiMatrix process(MultiMatrix source) {
        long t1 = SimpleGradient3x3.debugTime();
        QuickGradientByCross3x3 gradient = QuickGradientByCross3x3.newInstance((Class)source.elementType(), (long[])source.dimensions());
        long t2 = SimpleGradient3x3.debugTime();
        MultiMatrix result = source.mapChannels(arg_0 -> ((QuickGradientByCross3x3)gradient).filter(arg_0));
        long t3 = SimpleGradient3x3.debugTime();
        SimpleGradient3x3.logDebug(() -> String.format(Locale.US, "Simple 3x3 gradient of %s calculated in %.3f ms: %.3f initializing, %.3f gradient", source, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }
}

