/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.algart.arrays.Arrays;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePFixedArray;
import net.algart.contours.Contours;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.matrices.geometry.Resize;
import net.algart.executors.modules.cv.matrices.misc.Selector;
import net.algart.math.IPoint;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class DrawContours
extends MultiMatrix2DFilter {
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_IMAGE_POSITION = "image_position";
    public static final String OUTPUT_NUMBER_OF_OBJECTS = "number_of_objects";
    private DrawnFeatures drawnFeatures = DrawnFeatures.STRICT_BYTE_CONTOURS;
    private int strictByteMultiplier = 1;
    private DrawnContourKinds drawnContourKinds = DrawnContourKinds.EXTERNAL;
    private int firstIndex = 0;
    private int numberOfContours = 0;
    private boolean needToProcessDiagonals = false;
    private int dimX = 1000;
    private int dimY = 1000;
    private int scale = 1;
    private int imageStartX = 0;
    private int imageStartY = 0;
    private long randSeed = 0L;
    private boolean contrastBackground = false;

    public DrawContours() {
        this.addInputNumbers(INPUT_CONTOURS);
        this.addInputNumbers(INPUT_IMAGE_POSITION);
        this.addOutputScalar(OUTPUT_NUMBER_OF_OBJECTS);
    }

    public DrawnFeatures getDrawnFeatures() {
        return this.drawnFeatures;
    }

    public DrawContours setDrawnFeatures(DrawnFeatures drawnFeatures) {
        this.drawnFeatures = (DrawnFeatures)((Object)DrawContours.nonNull((Object)((Object)drawnFeatures)));
        return this;
    }

    public int getStrictByteMultiplier() {
        return this.strictByteMultiplier;
    }

    public DrawContours setStrictByteMultiplier(int strictByteMultiplier) {
        this.strictByteMultiplier = DrawContours.positive((int)strictByteMultiplier);
        return this;
    }

    public DrawnContourKinds getDrawnContourKinds() {
        return this.drawnContourKinds;
    }

    public DrawContours setDrawnContourKinds(DrawnContourKinds drawnContourKinds) {
        this.drawnContourKinds = (DrawnContourKinds)((Object)DrawContours.nonNull((Object)((Object)drawnContourKinds)));
        return this;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public DrawContours setFirstIndex(int firstIndex) {
        this.firstIndex = DrawContours.nonNegative((int)firstIndex);
        return this;
    }

    public int getNumberOfContours() {
        return this.numberOfContours;
    }

    public DrawContours setNumberOfContours(int numberOfContours) {
        this.numberOfContours = DrawContours.nonNegative((int)numberOfContours);
        return this;
    }

    public int getDimX() {
        return this.dimX;
    }

    public DrawContours setDimX(int dimX) {
        this.dimX = DrawContours.positive((int)dimX);
        return this;
    }

    public int getDimY() {
        return this.dimY;
    }

    public DrawContours setDimY(int dimY) {
        this.dimY = DrawContours.positive((int)dimY);
        return this;
    }

    public boolean isNeedToProcessDiagonals() {
        return this.needToProcessDiagonals;
    }

    public DrawContours setNeedToProcessDiagonals(boolean needToProcessDiagonals) {
        this.needToProcessDiagonals = needToProcessDiagonals;
        return this;
    }

    public int getScale() {
        return this.scale;
    }

    public DrawContours setScale(int scale) {
        this.scale = DrawContours.positive((int)scale);
        return this;
    }

    public int getImageStartX() {
        return this.imageStartX;
    }

    public DrawContours setImageStartX(int imageStartX) {
        this.imageStartX = imageStartX;
        return this;
    }

    public int getImageStartY() {
        return this.imageStartY;
    }

    public DrawContours setImageStartY(int imageStartY) {
        this.imageStartY = imageStartY;
        return this;
    }

    public long getRandSeed() {
        return this.randSeed;
    }

    public DrawContours setRandSeed(long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    public boolean isContrastBackground() {
        return this.contrastBackground;
    }

    public DrawContours setContrastBackground(boolean contrastBackground) {
        this.contrastBackground = contrastBackground;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        Contours contours = Contours.deserialize((int[])this.getInputNumbers(INPUT_CONTOURS).toIntArray());
        return this.process(contours, source);
    }

    public MultiMatrix2D process(Contours contours, MultiMatrix2D background) {
        IPoint originPoint;
        if (this.needToProcessDiagonals) {
            contours = contours.unpackContours(true);
        }
        long dimX = background == null ? (long)this.dimX : background.dimX() * (long)this.scale;
        long dimY = background == null ? (long)this.dimY : background.dimY() * (long)this.scale;
        SNumbers position = this.getInputNumbers(INPUT_IMAGE_POSITION, true);
        IPoint iPoint = originPoint = position.isProbableRectangularArea() ? position.toIRectangularArea().min() : position.toIPoint();
        if (originPoint == null) {
            originPoint = IPoint.valueOf((long)this.imageStartX, (long)this.imageStartY);
        }
        List<Object> resultChannels = null;
        if (background != null && !this.drawnFeatures.incrementing) {
            if (this.contrastBackground) {
                background = background.contrast();
            }
            background = background.toPrecisionIfNot(this.drawnFeatures.elementType);
            if (this.drawnFeatures.colored) {
                background = background.asOtherNumberOfChannels(3);
            }
            if (this.scale > 1) {
                Resize resize = new Resize();
                resize.setResizingMode(Resize.ResizingMode.NEAREST);
                resize.setDimX((double)dimX);
                resize.setDimY((double)dimY);
                background = resize.process(background);
            }
            resultChannels = MultiMatrix.cloneMatrices((List)background.allChannels());
        }
        if (resultChannels == null) {
            resultChannels = new LinkedList<Matrix>();
            for (int k = 0; k < (this.drawnFeatures.colored ? 3 : 1); ++k) {
                resultChannels.add(Arrays.SMM.newMatrix(UpdatablePArray.class, this.drawnFeatures.elementType, new long[]{dimX, dimY}));
            }
        }
        Random rnd = this.randSeed == 0L ? new Random() : new Random(this.randSeed);
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            for (Matrix channel : resultChannels) {
                this.drawContour((Matrix<? extends UpdatablePFixedArray>)channel.cast(UpdatablePFixedArray.class), contours, k, originPoint, rnd);
            }
        }
        MultiMatrix2D result = MultiMatrix.of2D(resultChannels);
        if (background != null && this.drawnFeatures.incrementing) {
            Selector selector = new Selector();
            selector.setSelectorType(Selector.SelectorType.BINARY_MATRIX);
            result = selector.process(new MultiMatrix[]{result, background, result}).asMultiMatrix2D();
        }
        this.getScalar(OUTPUT_NUMBER_OF_OBJECTS).setTo(contours.numberOfContours());
        return result;
    }

    protected boolean allowUninitializedInput() {
        return true;
    }

    private void drawContour(Matrix<? extends UpdatablePFixedArray> result, Contours contours, int contourIndex, IPoint origin, Random rnd) {
        if (origin.coordCount() != result.dimCount()) {
            throw new IllegalArgumentException("Different number of dimensions: " + origin.coordCount() + "-dimensional point (" + origin + ") and " + result.dimCount() + "-dimensional matrix (" + result + ")");
        }
        boolean internalContour = contours.isInternalContour(contourIndex);
        if (!this.drawnContourKinds.accept.test(internalContour)) {
            return;
        }
        if (contourIndex < this.firstIndex || this.numberOfContours > 0 && contourIndex - this.firstIndex >= this.numberOfContours) {
            return;
        }
        IntArray contour = contours.getContour(contourIndex);
        int objectLabel = contours.getObjectLabel(contourIndex);
        long n = contour.length();
        assert (n >= 2L) : "empty contour is impossible";
        long maxValue = ((UpdatablePFixedArray)result.array()).maxPossibleValue();
        long colorOrMaxValue = switch (this.drawnFeatures) {
            case DrawnFeatures.STRICT_BYTE_CONTOURS -> maxValue;
            case DrawnFeatures.NOT_INTERSECTED_LABELS_OF_CONTOURS -> objectLabel;
            case DrawnFeatures.NOT_INTERSECTED_INDEXES_OF_CONTOURS -> contourIndex + 1;
            case DrawnFeatures.NOT_INTERSECTED_RANDOMLY_COLORED_CONTOURS -> rnd.nextInt((int)maxValue);
            default -> throw new UnsupportedOperationException("Unsupported " + this.drawnFeatures);
        };
        Boolean internal = this.drawnFeatures.incrementing ? null : Boolean.valueOf(internalContour);
        int increment = this.drawnFeatures.incrementing ? this.strictByteMultiplier : 0;
        long lastX = (long)contour.getInt(n - 2L) - origin.x();
        long lastY = (long)contour.getInt(n - 1L) - origin.y();
        for (long i = 0L; i < n; i += 2L) {
            long y;
            long x = (long)contour.getInt(i) - origin.x();
            if (!DrawContours.drawHorizontalOrVerticalLine(result, (long)this.scale * lastX, (long)this.scale * lastY, (long)this.scale * x, (long)this.scale * (y = (long)contour.getInt(i + 1L) - origin.y()), colorOrMaxValue, internal, increment)) {
                throw new IllegalArgumentException("Cannot draw contours containing non-horizontal and non-vertical segments (" + lastX + "," + lastY + " - " + x + "," + y + ") between points #" + (i / 2L - 1L) + " and #" + i / 2L);
            }
            lastX = x;
            lastY = y;
        }
    }

    private static boolean drawHorizontalOrVerticalLine(Matrix<? extends UpdatablePFixedArray> result, long x1, long y1, long x2, long y2, long colorOrMaxValue, Boolean internal, int increment) {
        if (y1 == y2) {
            if (x1 == x2) {
                return true;
            }
            if (x1 < x2) {
                if (internal != null && internal.booleanValue()) {
                    --y1;
                }
                DrawContours.drawRow(result, x1, x2 - 1L, y1, colorOrMaxValue, increment);
            } else {
                if (internal != null && !internal.booleanValue()) {
                    --y1;
                }
                if (internal == null) {
                    DrawContours.drawRow(result, x2 + 1L, x1, y1, colorOrMaxValue, increment);
                } else {
                    DrawContours.drawRow(result, x2, x1 - 1L, y1, colorOrMaxValue, increment);
                }
            }
            return true;
        }
        if (x1 == x2) {
            if (y1 < y2) {
                if (internal != null && !internal.booleanValue()) {
                    --x1;
                }
                DrawContours.drawCol(result, x1, y1, y2 - 1L, colorOrMaxValue, increment);
            } else {
                if (internal != null && internal.booleanValue()) {
                    --x1;
                }
                if (internal == null) {
                    DrawContours.drawCol(result, x1, y2 + 1L, y1, colorOrMaxValue, increment);
                } else {
                    DrawContours.drawCol(result, x1, y2, y1 - 1L, colorOrMaxValue, increment);
                }
            }
            return true;
        }
        return false;
    }

    private static void drawRow(Matrix<? extends UpdatablePFixedArray> result, long minX, long maxX, long y, long colorOrMaxValue, int increment) {
        if (minX == maxX) {
            if (minX >= 0L && minX < result.dimX() && y >= 0L && y < result.dimY()) {
                DrawContours.drawElement((UpdatablePFixedArray)result.array(), result.index(minX, y), colorOrMaxValue, increment);
            }
        } else {
            DrawContours.drawElements((UpdatablePFixedArray)result.subMatrix(minX, y, maxX + 1L, y + 1L, Matrix.ContinuationMode.NAN_CONSTANT).array(), colorOrMaxValue, increment);
        }
    }

    private static void drawCol(Matrix<? extends UpdatablePFixedArray> result, long x, long minY, long maxY, long colorOrMaxValue, int increment) {
        if (minY == maxY) {
            if (minY >= 0L && minY < result.dimY() && x >= 0L && x < result.dimX()) {
                DrawContours.drawElement((UpdatablePFixedArray)result.array(), result.index(x, minY), colorOrMaxValue, increment);
            }
        } else {
            DrawContours.drawElements((UpdatablePFixedArray)result.subMatrix(x, minY, x + 1L, maxY + 1L, Matrix.ContinuationMode.NAN_CONSTANT).array(), colorOrMaxValue, increment);
        }
    }

    private static void drawElement(UpdatablePFixedArray array, long index, long colorOrMaxValue, int increment) {
        if (increment > 0) {
            array.setLong(index, Math.min(array.getLong(index) + (long)increment, colorOrMaxValue));
        } else {
            array.setLong(index, colorOrMaxValue);
        }
    }

    private static void drawElements(UpdatablePFixedArray array, long colorOrMaxValue, int increment) {
        if (increment > 0) {
            long n = array.length();
            for (long k = 0L; k < n; ++k) {
                array.setLong(k, Math.min(array.getLong(k) + (long)increment, colorOrMaxValue));
            }
        } else {
            long n = array.length();
            for (long k = 0L; k < n; ++k) {
                array.setLong(k, colorOrMaxValue);
            }
        }
    }

    public static enum DrawnFeatures {
        STRICT_BYTE_CONTOURS(Byte.TYPE, true, false),
        NOT_INTERSECTED_LABELS_OF_CONTOURS(Integer.TYPE, false, false),
        NOT_INTERSECTED_INDEXES_OF_CONTOURS(Integer.TYPE, false, false),
        NOT_INTERSECTED_RANDOMLY_COLORED_CONTOURS(Byte.TYPE, false, true);

        private final Class<?> elementType;
        private final boolean incrementing;
        private final boolean colored;

        private DrawnFeatures(Class<?> elementType, boolean incrementing, boolean colored) {
            this.elementType = elementType;
            this.incrementing = incrementing;
            this.colored = colored;
        }
    }

    public static enum DrawnContourKinds {
        ALL(isInternalContour -> true),
        EXTERNAL(isInternalContour -> isInternalContour == false),
        INTERNAL(isInternalContour -> isInternalContour);

        private final Predicate<Boolean> accept;

        private DrawnContourKinds(Predicate<Boolean> accept) {
            this.accept = accept;
        }
    }
}

