/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.imageio.ImageIO;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class MatrixTypeConversionsTest {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.printf("Usage: %s source_image_file%n", MatrixTypeConversionsTest.class.getName());
            return;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        MultiMatrix2D multiMatrix = MultiMatrix.of2DRGBA((List)MatrixIO.readImage((Path)sourceFile));
        System.out.printf("Loaded %s%n", multiMatrix);
        SMat m = SMat.of((MultiMatrix)multiMatrix);
        multiMatrix = m.toMultiMatrix2D();
        System.out.printf("-> port -> multi-matrix: %s%n", multiMatrix);
        MatrixIO.writeImage((Path)Paths.get(sourceFile + ".port2mm.png", new String[0]), (List)multiMatrix.allChannelsInRGBAOrder());
        Mat mat = O2SMat.toMat((SMat)m);
        System.out.printf("-> port -> mat: %s%n", multiMatrix);
        opencv_imgcodecs.imwrite((String)(sourceFile + ".port2mat.png"), (Mat)mat);
        BufferedImage bufferedImage = m.toBufferedImage();
        System.out.printf("-> port -> BufferedImage: %s%n", multiMatrix);
        ImageIO.write((RenderedImage)bufferedImage, "png", new File(sourceFile + ".port2bb.png"));
        SMat tempPort = SMat.of((BufferedImage)bufferedImage);
        multiMatrix = tempPort.toMultiMatrix2D();
        System.out.printf("-> port -> BufferedImage -> port -> multi-matrix: %s%n", multiMatrix);
        MatrixIO.writeImage((Path)Paths.get(sourceFile + ".bb2port2mm.png", new String[0]), (List)multiMatrix.allChannelsInRGBAOrder());
    }
}

