/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features.detection;

import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.common.MatToNumbers;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_imgproc.Vec4iVector;

public final class HoughLinesProbabilistic
extends MatToNumbers {
    public static final String OUTPUT_LINES = "lines";
    private double rho = 1.0;
    private double thetaInDegree = 1.0;
    private int threshold = 100;
    private double minLineLength = 0.0;
    private double maxLineGap = 0.0;

    public HoughLinesProbabilistic() {
        this.setDefaultOutputNumbers(OUTPUT_LINES);
    }

    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public double getThetaInDegree() {
        return this.thetaInDegree;
    }

    public void setThetaInDegree(double thetaInDegree) {
        this.thetaInDegree = thetaInDegree;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public double getMinLineLength() {
        return this.minLineLength;
    }

    public void setMinLineLength(double minLineLength) {
        this.minLineLength = minLineLength;
    }

    public double getMaxLineGap() {
        return this.maxLineGap;
    }

    public void setMaxLineGap(double maxLineGap) {
        this.maxLineGap = maxLineGap;
    }

    @Override
    public SNumbers analyse(Mat source) {
        try (Vec4iVector linesVector = new Vec4iVector();){
            opencv_imgproc.HoughLinesP((Mat)source, (Vec4iVector)linesVector, (double)this.rho, (double)Math.toRadians(this.thetaInDegree), (int)this.threshold, (double)this.minLineLength, (double)this.maxLineGap);
            SNumbers sNumbers = SNumbers.valueOfArray((Object)OTools.toIntArray(linesVector), (int)4);
            return sNumbers;
        }
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }
}

