/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.markers;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.executors.modules.core.numbers.conversions.JsonToColorPalette;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class PaintLabelledObjects
extends MultiMatrix2DFilter {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_BACKGROUND = "background";
    public static final String INPUT_PALETTE = "palette";
    public static final String INPUT_JSON_PALETTE = "json_palette";
    public static final String INPUT_JSON_NAMED_INDEXES = "json_named_indexes";
    private static final int ALPHA_CHANNEL = 3;
    private Class<?> elementType = Byte.TYPE;
    private boolean rawValues = false;
    private boolean randomPalette = false;
    private long randSeed = 0L;
    private int indexingBase = 1;
    private boolean processAlpha = false;
    private int defaultNumberOfChannels = 3;

    public PaintLabelledObjects() {
        this.setDefaultInputMat(INPUT_LABELS);
        this.addInputMat(INPUT_BACKGROUND);
        this.addInputNumbers(INPUT_PALETTE);
        this.addInputScalar(INPUT_JSON_PALETTE);
        this.addInputScalar(INPUT_JSON_NAMED_INDEXES);
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public PaintLabelledObjects setElementType(Class<?> elementType) {
        this.elementType = (Class)PaintLabelledObjects.nonNull(elementType, (String)"element type");
        return this;
    }

    public final PaintLabelledObjects setElementType(String elementType) {
        return this.setElementType(MultiMatrixGenerator.elementType((String)elementType));
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public PaintLabelledObjects setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public boolean isRandomPalette() {
        return this.randomPalette;
    }

    public PaintLabelledObjects setRandomPalette(boolean randomPalette) {
        this.randomPalette = randomPalette;
        return this;
    }

    public long getRandSeed() {
        return this.randSeed;
    }

    public PaintLabelledObjects setRandSeed(long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    public int getIndexingBase() {
        return this.indexingBase;
    }

    public PaintLabelledObjects setIndexingBase(int indexingBase) {
        this.indexingBase = PaintLabelledObjects.nonNegative((int)indexingBase);
        return this;
    }

    public boolean isProcessAlpha() {
        return this.processAlpha;
    }

    public PaintLabelledObjects setProcessAlpha(boolean processAlpha) {
        this.processAlpha = processAlpha;
        return this;
    }

    public int getDefaultNumberOfChannels() {
        return this.defaultNumberOfChannels;
    }

    public PaintLabelledObjects setDefaultNumberOfChannels(int defaultNumberOfChannels) {
        this.defaultNumberOfChannels = defaultNumberOfChannels;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix) {
        MultiMatrix2D background = this.getInputMat(INPUT_BACKGROUND, true).toMultiMatrix2D();
        SNumbers colors = this.getInputNumbers(INPUT_PALETTE, true);
        if (!colors.isInitialized()) {
            SScalar jsonPalette = this.getInputScalar(INPUT_JSON_PALETTE, true);
            if (jsonPalette.isInitialized()) {
                SScalar jsonNamedIndexes = this.getInputScalar(INPUT_JSON_NAMED_INDEXES, true);
                try (JsonToColorPalette executor = new JsonToColorPalette().setIndexingBase(this.indexingBase).setNumberOfChannels(this.defaultNumberOfChannels);){
                    colors = executor.process(jsonPalette.getValue(), jsonNamedIndexes.getValue());
                }
            } else if (!this.randomPalette) {
                throw new IllegalArgumentException("Input \"palette\" or \"json_palette\" must have initialized data, if random palette flag is not set");
            }
        }
        return this.process(labelsMatrix, background, colors);
    }

    public MultiMatrix2D process(MultiMatrix2D labelsMatrix, MultiMatrix2D background, SNumbers palette) {
        Objects.requireNonNull(labelsMatrix, "Null labels");
        if (!this.randomPalette) {
            Objects.requireNonNull(palette, "Null palette");
        } else if (palette == null || !palette.isInitialized()) {
            palette = SNumbers.zeros(Double.TYPE, (int)0, (int)this.defaultNumberOfChannels);
        }
        labelsMatrix.checkDimensionEquality((MultiMatrix)background, INPUT_LABELS, INPUT_BACKGROUND);
        int blockLength = palette.getBlockLength();
        assert (blockLength >= 1);
        if (this.processAlpha && 3 >= blockLength) {
            throw new IllegalArgumentException("Too low number of channels in the palette (" + blockLength + ") to process alpha: if you sets \"process alpha-channel\" flag, palette must have at least 4 channels");
        }
        int numberOfColors = palette.n();
        int numberOfChannels = background != null ? background.numberOfChannels() : Math.min(blockLength, 512);
        int[] labels = labelsMatrix.channel(0).toInt();
        float[] paletteForMissing = null;
        if (this.randomPalette) {
            int maxLabel = 0;
            for (int v : labels) {
                if (v <= maxLabel) continue;
                maxLabel = v;
            }
            paletteForMissing = new float[Math.max(0, (maxLabel -= this.indexingBase) + 1 - numberOfColors)];
        }
        ArrayList<Matrix> coloredChannels = new ArrayList<Matrix>();
        Random rnd = this.randSeed == 0L ? new Random() : new Random(this.randSeed);
        float[] alphaForMissing = null;
        if (this.processAlpha && this.randomPalette) {
            alphaForMissing = new float[paletteForMissing.length];
            for (int j = 0; j < paletteForMissing.length; ++j) {
                alphaForMissing[j] = (float)(0.2 + rnd.nextDouble() * 0.8);
            }
        }
        for (int channelIndex = 0; channelIndex < numberOfChannels; ++channelIndex) {
            float[] values;
            int colorChannelIndex = Math.min(channelIndex, blockLength - 1);
            float[] fArray = values = background == null ? new float[labels.length] : background.asPrecision(Float.TYPE).channel(channelIndex).toFloat();
            if (this.randomPalette) {
                assert (paletteForMissing != null);
                for (int j = 0; j < paletteForMissing.length; ++j) {
                    paletteForMissing[j] = (float)rnd.nextDouble();
                }
            }
            if (this.processAlpha) {
                if (channelIndex != 3) {
                    for (i = 0; i < values.length; ++i) {
                        double alpha;
                        double newValue;
                        label = labels[i] - this.indexingBase;
                        if (label >= 0 && label < numberOfColors) {
                            newValue = palette.getValue(label, colorChannelIndex);
                            alpha = palette.getValue(label, 3);
                        } else {
                            if (!this.randomPalette || label < numberOfColors) continue;
                            assert (paletteForMissing != null);
                            newValue = paletteForMissing[label - numberOfColors];
                            alpha = alphaForMissing[label - numberOfColors];
                        }
                        values[i] = (float)(alpha >= 1.0 ? newValue : alpha * newValue + (1.0 - alpha) * (double)values[i]);
                    }
                } else {
                    for (i = 0; i < values.length; ++i) {
                        label = labels[i] - this.indexingBase;
                        if ((label < 0 || label >= numberOfColors) && (!this.randomPalette || label < numberOfColors)) continue;
                        values[i] = 1.0f;
                    }
                }
            } else {
                for (i = 0; i < values.length; ++i) {
                    label = labels[i] - this.indexingBase;
                    if (label >= 0 && label < numberOfColors) {
                        values[i] = (float)palette.getValue(label, colorChannelIndex);
                        continue;
                    }
                    if (!this.randomPalette || label < numberOfColors) continue;
                    assert (paletteForMissing != null);
                    values[i] = paletteForMissing[label - numberOfColors];
                }
            }
            Matrix matrix = Matrices.matrix((Array)FloatArray.as((float[])values), (long[])labelsMatrix.dimensions());
            if (this.rawValues) {
                matrix = Matrices.asFuncMatrix((Func)Func.IDENTITY, (Class)Arrays.type(PArray.class, this.elementType), (Matrix)matrix);
            }
            coloredChannels.add(matrix);
        }
        MultiMatrix2D result = MultiMatrix.valueOf2D(coloredChannels);
        return this.rawValues ? result : result.asPrecision(this.elementType);
    }
}

