/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Arrays;
import net.algart.arrays.JArrays;

class SimpleIntPseudoStack {
    private final int[] values;
    private int size = 0;

    public SimpleIntPseudoStack(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity");
        }
        this.values = new int[capacity];
    }

    public int capacity() {
        return this.values.length;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void push(int value) {
        if (this.size >= this.values.length) {
            throw new IllegalStateException("Stack overflow");
        }
        this.values[this.size++] = value;
    }

    public int remove(int value, int defaultResult) {
        int k;
        if (this.size == 0) {
            throw new IllegalStateException("Unbalanced opening/closing brackets");
        }
        --this.size;
        int last = this.values[this.size];
        if (last == value) {
            return this.size == 0 ? defaultResult : this.values[k];
        }
        for (k = this.size - 1; k >= 0; --k) {
            int v = this.values[k];
            this.values[k] = last;
            last = v;
            if (v != value) continue;
            return this.size == 0 ? defaultResult : this.values[this.size];
        }
        throw new IllegalStateException("Invalid pseudo-stack: " + value + " not found here");
    }

    public String toString() {
        return "pseudo-stack of " + this.size + "/" + this.values.length + " integers: [" + JArrays.toString((int[])Arrays.copyOf(this.values, this.size), (String)", ", (int)1024) + "]";
    }

    public static void main(String[] args) {
        SimpleIntPseudoStack pseudoStack = new SimpleIntPseudoStack(5);
        pseudoStack.push(5);
        System.out.println(pseudoStack);
        pseudoStack.push(10);
        System.out.println(pseudoStack);
        pseudoStack.push(10);
        System.out.println(pseudoStack);
        pseudoStack.push(10);
        System.out.println(pseudoStack);
        int v = pseudoStack.remove(10, -1);
        System.out.println(pseudoStack + ": " + v);
        v = pseudoStack.remove(5, -1);
        System.out.println(pseudoStack + ": " + v + " (removed 5)");
        v = pseudoStack.remove(10, -1);
        System.out.println(pseudoStack + ": " + v + " (removed 10)");
        v = pseudoStack.remove(10, -1);
        System.out.println(pseudoStack + ": " + v + " (removed 10)");
        pseudoStack.push(15);
        System.out.println(pseudoStack);
        v = pseudoStack.remove(15, -1);
        System.out.println(pseudoStack + ": " + v + " (removed 15)");
    }
}

