/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.PatternSpecificationParser;
import net.algart.math.Point;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.morphology.Morphology;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MorphologyOperation {
    DILATION{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.dilation(matrix, pattern);
        }
    }
    ,
    EROSION{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.erosion(matrix, pattern);
        }
    }
    ,
    CLOSING{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.closing(matrix, pattern, Morphology.SubtractionMode.NONE);
        }
    }
    ,
    OPENING{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.opening(matrix, pattern, Morphology.SubtractionMode.NONE);
        }
    }
    ,
    WEAK_DILATION{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.weakDilation(matrix, pattern);
        }
    }
    ,
    WEAK_EROSION{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.weakErosion(matrix, pattern);
        }
    }
    ,
    WEAK_CLOSING{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.maskedErosionDilation(matrix, MorphologyOperation.boundary(pattern, executor), pattern);
        }
    }
    ,
    WEAK_OPENING{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.maskedDilationErosion(matrix, MorphologyOperation.boundary(pattern, executor), pattern);
        }
    }
    ,
    EXTERNAL_GRADIENT{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.dilation(matrix, pattern, Morphology.SubtractionMode.SUBTRACT_SRC_FROM_RESULT);
        }
    }
    ,
    INTERNAL_GRADIENT{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.erosion(matrix, pattern, Morphology.SubtractionMode.SUBTRACT_RESULT_FROM_SRC);
        }
    }
    ,
    BLACK_HAT{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.closing(matrix, pattern, Morphology.SubtractionMode.SUBTRACT_SRC_FROM_RESULT);
        }
    }
    ,
    TOP_HAT{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.opening(matrix, pattern, Morphology.SubtractionMode.SUBTRACT_RESULT_FROM_SRC);
        }
    }
    ,
    CRATERS{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.erosionDilation(matrix, MorphologyOperation.boundary(pattern, executor), pattern, Morphology.SubtractionMode.SUBTRACT_SRC_FROM_RESULT);
        }
    }
    ,
    PEAKS{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.dilationErosion(matrix, MorphologyOperation.boundary(pattern, executor), pattern, Morphology.SubtractionMode.SUBTRACT_RESULT_FROM_SRC);
        }
    }
    ,
    BEUCHER_GRADIENT{

        @Override
        Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern, Executor executor) {
            return morphology.beucherGradient(matrix, pattern);
        }
    };


    public Matrix<? extends UpdatablePArray> perform(Morphology morphology, Matrix<? extends PArray> matrix, Pattern pattern) {
        return this.perform(morphology, matrix, pattern, null);
    }

    public static Pattern crossPattern(int numberOfDimensions) {
        return Patterns.newSphereIntegerPattern((Point)Point.origin((int)numberOfDimensions), (double)1.000001);
    }

    public static Pattern cube3Pattern(int numberOfDimensions) {
        return MorphologyFilter.Shape.CUBE.newPattern(numberOfDimensions, 3);
    }

    abstract Matrix<? extends UpdatablePArray> perform(Morphology var1, Matrix<? extends PArray> var2, Pattern var3, Executor var4);

    private static Pattern boundary(Pattern main, Executor executor) {
        Pattern result;
        long t1 = executor == null ? 0L : System.nanoTime();
        Pattern carcassPattern = PatternSpecificationParser.isRectangularInteger(main) ? MorphologyOperation.cube3Pattern(main.dimCount()) : MorphologyOperation.crossPattern(main.dimCount());
        Pattern erosion = main.minkowskiSubtract(carcassPattern);
        Pattern pattern = result = erosion == null ? main : PatternSpecificationParser.subtract(main, erosion);
        if (executor != null) {
            long t2 = System.nanoTime();
            executor.addServiceTime(t2 - t1);
        }
        return result;
    }
}

