/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.List;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.matrices.conversions.ChangePrecision;
import net.algart.executors.modules.core.matrices.geometry.ContinuationMode;
import net.algart.executors.modules.cv.matrices.derivatives.CombiningMatricesMetric;
import net.algart.executors.modules.opencv.matrices.filtering.GaussianBlur;
import net.algart.matrices.linearfiltering.BasicConvolution;
import net.algart.matrices.linearfiltering.ContinuedConvolution;
import net.algart.matrices.linearfiltering.Convolution;
import net.algart.multimatrix.MultiMatrix2D;

public abstract class MultichannelDerivativesFilter
extends MultiMatrix2DFilter {
    private boolean gaussianBlurOfSource = true;
    private int gaussianBlurKernelSizeX = 5;
    private int gaussianBlurKernelSizeY = 0;
    private ContinuationMode continuationMode = ContinuationMode.MIRROR_CYCLIC;
    private CombiningMatricesMetric combiningChannelsMetric = CombiningMatricesMetric.NORMALIZED_EUCLIDEAN;
    private double[] channelsWeights = new double[0];
    private double additionalMultiplier = 1.0;
    private boolean onlyFirst3Channels = true;
    private boolean floatResult = true;

    protected MultichannelDerivativesFilter() {
    }

    public boolean isGaussianBlurOfSource() {
        return this.gaussianBlurOfSource;
    }

    public MultichannelDerivativesFilter setGaussianBlurOfSource(boolean gaussianBlurOfSource) {
        this.gaussianBlurOfSource = gaussianBlurOfSource;
        return this;
    }

    public int getGaussianBlurKernelSizeX() {
        return this.gaussianBlurKernelSizeX;
    }

    public MultichannelDerivativesFilter setGaussianBlurKernelSizeX(int gaussianBlurKernelSizeX) {
        this.gaussianBlurKernelSizeX = MultichannelDerivativesFilter.nonNegative((int)gaussianBlurKernelSizeX);
        return this;
    }

    public int getGaussianBlurKernelSizeY() {
        return this.gaussianBlurKernelSizeY;
    }

    public MultichannelDerivativesFilter setGaussianBlurKernelSizeY(int gaussianBlurKernelSizeY) {
        this.gaussianBlurKernelSizeY = MultichannelDerivativesFilter.nonNegative((int)gaussianBlurKernelSizeY);
        return this;
    }

    public ContinuationMode getContinuationMode() {
        return this.continuationMode;
    }

    public MultichannelDerivativesFilter setContinuationMode(ContinuationMode continuationMode) {
        this.continuationMode = (ContinuationMode)MultichannelDerivativesFilter.nonNull((Object)continuationMode);
        return this;
    }

    public CombiningMatricesMetric getCombiningChannelsMetric() {
        return this.combiningChannelsMetric;
    }

    public MultichannelDerivativesFilter setCombiningChannelsMetric(CombiningMatricesMetric combiningChannelsMetric) {
        this.combiningChannelsMetric = (CombiningMatricesMetric)((Object)MultichannelDerivativesFilter.nonNull((Object)((Object)combiningChannelsMetric)));
        return this;
    }

    public double[] getChannelsWeights() {
        return this.channelsWeights;
    }

    public MultichannelDerivativesFilter setChannelsWeights(double[] channelsWeights) {
        this.channelsWeights = (double[])((double[])MultichannelDerivativesFilter.nonNull((Object)channelsWeights)).clone();
        return this;
    }

    public MultichannelDerivativesFilter setChannelsWeights(String channelsWeights) {
        this.channelsWeights = new SScalar((String)MultichannelDerivativesFilter.nonNull((Object)channelsWeights)).toDoubles();
        return this;
    }

    public double getAdditionalMultiplier() {
        return this.additionalMultiplier;
    }

    public MultichannelDerivativesFilter setAdditionalMultiplier(double additionalMultiplier) {
        this.additionalMultiplier = additionalMultiplier;
        return this;
    }

    public boolean isOnlyFirst3Channels() {
        return this.onlyFirst3Channels;
    }

    public MultichannelDerivativesFilter setOnlyFirst3Channels(boolean onlyFirst3Channels) {
        this.onlyFirst3Channels = onlyFirst3Channels;
        return this;
    }

    public boolean isFloatResult() {
        return this.floatResult;
    }

    public MultichannelDerivativesFilter setFloatResult(boolean floatResult) {
        this.floatResult = floatResult;
        return this;
    }

    public void process() {
        if (this.gaussianBlurOfSource) {
            SMat inputMat = this.getInputMat();
            if (this.floatResult && !inputMat.getDepth().isFloatingPoint()) {
                try (ChangePrecision changePrecision = new ChangePrecision();){
                    changePrecision.setRawCast(false);
                    changePrecision.setElementType(Float.TYPE);
                    inputMat.setTo(changePrecision.process(inputMat));
                }
            }
            GaussianBlur.blurI\u05dePlace(inputMat, this.gaussianBlurKernelSizeX, this.gaussianBlurKernelSizeY, false);
        }
        super.process();
    }

    public abstract MultiMatrix2D process(MultiMatrix2D var1);

    public Convolution createConvolution() {
        BasicConvolution convolution = BasicConvolution.getInstance(null, (boolean)false);
        if (this.continuationMode.continuationModeOrNull() != null) {
            convolution = ContinuedConvolution.getInstance((Convolution)convolution, (Matrix.ContinuationMode)this.continuationMode.continuationModeOrNull());
        }
        return convolution;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected final MultiMatrix2D preprocess(MultiMatrix2D source) {
        if (this.floatResult && !source.isFloatingPoint()) {
            source = source.asPrecision(Float.TYPE).clone();
        }
        if (this.combiningChannelsMetric.isSingleChannel()) {
            source = source.isColor() ? source.asMono().clone() : source.asOtherNumberOfChannels(1);
        } else if (this.onlyFirst3Channels) {
            source = source.asOtherNumberOfChannels(Math.min(source.numberOfChannels(), 3));
        }
        return source;
    }

    protected final Matrix<? extends PArray> combineResult(Class<? extends PArray> requiredType, List<Matrix<? extends PArray>> processedChannels) {
        return Matrices.clone(this.combiningChannelsMetric.combine(requiredType, processedChannels, this.channelsWeights, this.additionalMultiplier));
    }

    protected static Class<? extends PFloatingArray> floatingType(Class<?> elementType) {
        return elementType == Double.TYPE ? DoubleArray.class : FloatArray.class;
    }
}

