/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSegmentationWithBoundaries;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

abstract class AbstractSuperpixel
extends AbstractSegmentationWithBoundaries {
    public static final String OUTPUT_LABELS = "labels";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public AbstractSuperpixel() {
        this.setDefaultOutputMat(OUTPUT_LABELS);
        this.setUseGPU(false);
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public void setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)AbstractSuperpixel.nonNull((Object)indexingBase);
    }

    void makeLabelsPositiveIfRequired(Mat labels) {
        if (this.indexingBase.start != 0) {
            try (Scalar startIndex = new Scalar((double)this.indexingBase.start);){
                opencv_core.add((Mat)labels, (Scalar)startIndex).asMat().copyTo(labels);
            }
        }
    }

    void makeLabelsPositiveIfRequired(UMat labels) {
        if (this.indexingBase.start != 0) {
            try (Scalar startIndex = new Scalar((double)this.indexingBase.start);
                 UMat startIndexUMat = new UMat(labels.rows(), labels.cols(), labels.type(), startIndex);){
                opencv_core.add((UMat)labels, (UMat)startIndexUMat, (UMat)labels);
            }
        }
    }
}

