/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.geometry;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CopyMakeBorder
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private int leftMargin = 0;
    private int topMargin = 0;
    private int rightMargin = 0;
    private int bottomMargin = 0;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;
    private double constantValue;

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = CopyMakeBorder.nonNegative((int)leftMargin);
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = CopyMakeBorder.nonNegative((int)topMargin);
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = CopyMakeBorder.nonNegative((int)rightMargin);
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = CopyMakeBorder.nonNegative((int)bottomMargin);
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)CopyMakeBorder.nonNull((Object)((Object)borderType)));
    }

    public double getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(double constantValue) {
        this.constantValue = constantValue;
    }

    @Override
    public void process(Mat result, Mat source) {
        double filler = this.constantValue * OTools.maxPossibleValue(source);
        try (Scalar value = OTools.scalarBGRA(filler, 0.0);){
            opencv_core.copyMakeBorder((Mat)source, (Mat)result, (int)this.topMargin, (int)this.bottomMargin, (int)this.leftMargin, (int)this.rightMargin, (int)this.borderType.code(), (Scalar)value);
        }
    }

    @Override
    public void process(UMat result, UMat source) {
        double filler = this.constantValue * OTools.maxPossibleValue(source);
        try (Scalar value = OTools.scalarBGRA(filler, 0.0);){
            opencv_core.copyMakeBorder((UMat)source, (UMat)result, (int)this.topMargin, (int)this.bottomMargin, (int)this.leftMargin, (int)this.rightMargin, (int)this.borderType.code(), (Scalar)value);
        }
    }
}

