/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.thresholds;

import java.util.Arrays;
import java.util.Locale;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.executors.modules.cv.matrices.objects.binary.components.FindConnectedWithMask;
import net.algart.math.functions.Func;
import net.algart.math.functions.RectangularFunc;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SimpleThreshold
extends MultiMatrixFilter {
    public static final String INPUT_MASK = "mask";
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean hysteresis = false;
    private double hysteresisMin = Double.NEGATIVE_INFINITY;
    private double hysteresisMax = Double.POSITIVE_INFINITY;
    private boolean invert = false;
    private boolean rawValues = false;

    public SimpleThreshold() {
        this.addInputMat(INPUT_MASK);
    }

    public double getMin() {
        return this.min;
    }

    public SimpleThreshold setMin(double min) {
        this.min = min;
        return this;
    }

    public SimpleThreshold setMin(String min) {
        this.min = SimpleThreshold.doubleOrNegativeInfinity((String)min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public SimpleThreshold setMax(double max) {
        this.max = max;
        return this;
    }

    public SimpleThreshold setMax(String max) {
        this.max = SimpleThreshold.doubleOrPositiveInfinity((String)max);
        return this;
    }

    public boolean isHysteresis() {
        return this.hysteresis;
    }

    public SimpleThreshold setHysteresis(boolean hysteresis) {
        this.hysteresis = hysteresis;
        return this;
    }

    public double getHysteresisMin() {
        return this.hysteresisMin;
    }

    public SimpleThreshold setHysteresisMin(double hysteresisMin) {
        this.hysteresisMin = hysteresisMin;
        return this;
    }

    public SimpleThreshold setHysteresisMin(String hysteresisMin) {
        this.hysteresisMin = SimpleThreshold.doubleOrNegativeInfinity((String)hysteresisMin);
        return this;
    }

    public double getHysteresisMax() {
        return this.hysteresisMax;
    }

    public SimpleThreshold setHysteresisMax(double hysteresisMax) {
        this.hysteresisMax = hysteresisMax;
        return this;
    }

    public SimpleThreshold setHysteresisMax(String hysteresisMax) {
        this.hysteresisMax = SimpleThreshold.doubleOrPositiveInfinity((String)hysteresisMax);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public SimpleThreshold setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public SimpleThreshold setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        return this.process(source, this.getInputMat(INPUT_MASK, true).toMultiMatrix());
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        return this.process((MultiMatrix)source).asMultiMatrix2D();
    }

    public MultiMatrix process(MultiMatrix source, MultiMatrix mask) {
        if (this.hysteresis && source.dimCount() != 2) {
            throw new IllegalArgumentException("Only 2-dimensional matrices allowed for hysteresis");
        }
        Matrix intensity = source.intensityChannel();
        double scale = this.rawValues ? 1.0 : ((PArray)intensity.array()).maxPossibleValue(1.0);
        double inValue = this.invert ? 0.0 : 1.0;
        double outValue = this.invert ? 1.0 : 0.0;
        long t1 = SimpleThreshold.debugTime();
        MultiMatrix result = MultiMatrix.valueOfMono((Matrix)Matrices.asFuncMatrix((Func)RectangularFunc.getInstance((double)(this.min * scale), (double)(this.max * scale), (double)inValue, (double)outValue), BitArray.class, (Matrix)intensity)).clone();
        long t2 = SimpleThreshold.debugTime();
        if (this.hysteresis) {
            MultiMatrix2D hysteresisResult = MultiMatrix.valueOf2DMono((Matrix)Matrices.asFuncMatrix((Func)RectangularFunc.getInstance((double)(this.hysteresisMin * scale), (double)(this.hysteresisMax * scale), (double)inValue, (double)outValue), BitArray.class, (Matrix)intensity)).clone();
            try (FindConnectedWithMask filter = new FindConnectedWithMask();){
                filter.setMode(RetainOrRemoveMode.RETAIN);
                result = filter.process(Arrays.asList(hysteresisResult, result));
            }
        }
        long t3 = SimpleThreshold.debugTime();
        if (mask != null) {
            result = result.min(mask).clone();
        }
        long t4 = SimpleThreshold.debugTime();
        SimpleThreshold.logDebug(() -> String.format(Locale.US, "Simple threshold of %s calculated in %.3f ms: %.3f threshold, %.3f histeresis, %.3f masking", source, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
        return result;
    }
}

