/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import net.algart.arrays.MutablePNumberArray;
import net.algart.math.IRectangularArea;
import net.algart.math.RectangularArea;
import net.algart.matrices.scanning.Boundary2DSimpleMeasurer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BoundaryParameter {
    AREA(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.AREA}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return measurer.area() * (pixelSize * pixelSize);
        }
    }
    ,
    SQRT_AREA(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.AREA}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return Math.sqrt(Math.abs(measurer.area())) * pixelSize;
        }
    }
    ,
    PERIMETER(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.PERIMETER}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return measurer.perimeter() * pixelSize;
        }
    }
    ,
    SIZE(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.COORD_RANGES}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return 4.octagonBasedSize(measurer) * pixelSize;
        }
    }
    ,
    SHAPE_FACTOR(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.AREA, Boundary2DSimpleMeasurer.ObjectParameter.PERIMETER}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return 5.shapeFactorCircularity(measurer.area(), measurer.perimeter());
        }
    }
    ,
    CONTAINING_OCTAGON_AREA(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.COORD_RANGES}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            double x1 = measurer.minX();
            double x2 = measurer.maxX();
            double y1 = measurer.minY();
            double y2 = measurer.maxY();
            double xPy1 = measurer.minXPlusY();
            double xPy2 = measurer.maxXPlusY();
            double xMy1 = measurer.minXMinusY();
            double xMy2 = measurer.maxXMinusY();
            double rectanglesArea = (x2 - x1) * (y2 - y1);
            double trianglesArea = 0.5 * (x2 + y2 - xPy2) * (x2 + y2 - xPy2 + 1.0) + 0.5 * (xPy1 - (x1 + y1)) * (xPy1 - (x1 + y1) + 1.0) + 0.5 * (x2 - y1 - xMy2) * (x2 - y1 - xMy2 + 1.0) + 0.5 * (xMy1 - (x1 - y2)) * (xMy1 - (x1 - y2) + 1.0);
            return (rectanglesArea - trianglesArea) * (pixelSize * pixelSize);
        }
    }
    ,
    CENTROID(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.CENTROID}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            throw new UnsupportedOperationException("getStatistics() has no sense for " + this);
        }
    }
    ,
    CONTAINING_RECTANGLE(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.COORD_RANGES}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            throw new UnsupportedOperationException("getStatistics() has no sense for " + this);
        }
    }
    ,
    NESTING_LEVEL(new Boundary2DSimpleMeasurer.ObjectParameter[]{Boundary2DSimpleMeasurer.ObjectParameter.PERIMETER}){

        @Override
        double getStatistics(Boundary2DSimpleMeasurer measurer, double pixelSize) {
            return measurer.nestingLevel();
        }
    };

    private static final double SQRT05;
    private final EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> objectParameters;

    private BoundaryParameter(Boundary2DSimpleMeasurer.ObjectParameter ... objectParameters) {
        this.objectParameters = EnumSet.copyOf(Arrays.asList(objectParameters));
    }

    public EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> objectParameters() {
        return EnumSet.copyOf(this.objectParameters);
    }

    abstract double getStatistics(Boundary2DSimpleMeasurer var1, double var2);

    public void getStatistics(MutablePNumberArray result, Boundary2DSimpleMeasurer measurer, double pixelSize) {
        switch (this) {
            case CENTROID: {
                result.addDouble(measurer.centroidX() * pixelSize);
                result.addDouble(measurer.centroidY() * pixelSize);
                break;
            }
            case CONTAINING_RECTANGLE: {
                double minX = measurer.minX() * pixelSize;
                double minY = measurer.minY() * pixelSize;
                double maxX = measurer.maxX() * pixelSize;
                double maxY = measurer.maxY() * pixelSize;
                BoundaryParameter.addRectangle(result, minX, minY, maxX, maxY);
                break;
            }
            default: {
                result.addDouble(this.getStatistics(measurer, pixelSize));
            }
        }
    }

    public int parameterLength() {
        return switch (this) {
            case CONTAINING_RECTANGLE -> 4;
            case CENTROID -> 2;
            default -> 1;
        };
    }

    public static void addRectangle(MutablePNumberArray result, double minX, double minY, double maxX, double maxY) {
        Objects.requireNonNull(result, "Null result");
        result.addDouble(0.5 * (minX + maxX));
        result.addDouble(0.5 * (minY + maxY));
        result.addDouble(maxX - minX);
        result.addDouble(maxY - minY);
    }

    public static void addRectangle(float[] result, int offset, double minX, double minY, double maxX, double maxY) {
        result[offset++] = (float)(0.5 * (minX + maxX));
        result[offset++] = (float)(0.5 * (minY + maxY));
        result[offset++] = (float)(maxX - minX);
        result[offset] = (float)(maxY - minY);
    }

    public static void addRectangle(double[] result, int offset, double minX, double minY, double maxX, double maxY) {
        result[offset++] = 0.5 * (minX + maxX);
        result[offset++] = 0.5 * (minY + maxY);
        result[offset++] = maxX - minX;
        result[offset] = maxY - minY;
    }

    public static void addRectangle(double[] result, int offset, IRectangularArea r) {
        result[offset++] = 0.5 * ((double)r.minX() + (double)r.maxX());
        result[offset++] = 0.5 * ((double)r.minY() + (double)r.maxY());
        result[offset++] = r.sizeX();
        result[offset] = r.sizeY();
    }

    public static RectangularArea getRectangle(double[] array, int offset) {
        double x = array[offset];
        double y = array[offset + 1];
        double sizeXHalf = 0.5 * array[offset + 2];
        double sizeYHalf = 0.5 * array[offset + 3];
        return RectangularArea.valueOf((double)(x - sizeXHalf), (double)(y - sizeYHalf), (double)(x + sizeXHalf), (double)(y + sizeYHalf));
    }

    public static EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> objectParameters(Collection<BoundaryParameter> parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> result = EnumSet.noneOf(Boundary2DSimpleMeasurer.ObjectParameter.class);
        for (BoundaryParameter parameter : parameters) {
            result.addAll(parameter.objectParameters);
        }
        return result;
    }

    public static boolean needSecondBuffer(Collection<BoundaryParameter> parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        return parameters.contains((Object)NESTING_LEVEL);
    }

    public static double shapeFactorCircularity(double area, double perimeter) {
        return Math.sqrt(Math.abs(area) * (Math.PI * 4)) / perimeter;
    }

    public static double octagonBasedSize(Boundary2DSimpleMeasurer m) {
        double straightSize = Math.max(m.maxX() - m.minX(), m.maxY() - m.minY());
        double diagonalSize = Math.max(m.maxXPlusY() - m.minXPlusY(), m.maxXMinusY() - m.minXMinusY());
        return Math.max(straightSize, SQRT05 * diagonalSize);
    }

    static {
        SQRT05 = 0.5 * Math.sqrt(2.0);
    }
}

