/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ReindexLabels
extends MultiMatrix2DFilter {
    public static final String INPUT_LABELS = "labels";
    public static final String OUTPUT_LABELS = "labels";
    public static final String OUTPUT_RESTORING_TABLE = "restoring_table";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private boolean includeReservedInRestoringTable = false;

    public ReindexLabels() {
        this.setDefaultInputMat("labels");
        this.setDefaultOutputMat("labels");
        this.addOutputNumbers(OUTPUT_RESTORING_TABLE);
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public ReindexLabels setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)ReindexLabels.nonNull((Object)indexingBase);
        return this;
    }

    public boolean isIncludeReservedInRestoringTable() {
        return this.includeReservedInRestoringTable;
    }

    public ReindexLabels setIncludeReservedInRestoringTable(boolean includeReservedInRestoringTable) {
        this.includeReservedInRestoringTable = includeReservedInRestoringTable;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D labels) {
        Objects.requireNonNull(labels, "Null labels");
        long t1 = ReindexLabels.debugTime();
        int[] labelsArray = labels.channel(0).toInt();
        int[] reindexTable = ReindexLabels.reindex(labelsArray, this.indexingBase.start, this.includeReservedInRestoringTable);
        long t2 = ReindexLabels.debugTime();
        ReindexLabels.logDebug(() -> String.format(Locale.US, "Labels %s reindexed: %.3f ms", labels, (double)(t2 - t1) * 1.0E-6));
        this.getNumbers(OUTPUT_RESTORING_TABLE).setTo(reindexTable, 1);
        return MultiMatrix.valueOf2DMono((Matrix)Matrix.as((Object)labelsArray, (long[])labels.dimensions()));
    }

    public static int[] reindex(int[] labels, int indexingBase, boolean includeReservedInRestoringTable) {
        Objects.requireNonNull(labels, "Null labels");
        if (indexingBase < 0) {
            throw new IllegalArgumentException("Negative indexing base " + indexingBase);
        }
        int maxLabel = Integer.MIN_VALUE;
        for (int label : labels) {
            maxLabel = Math.max(maxLabel, label);
        }
        if (maxLabel <= indexingBase) {
            int[] result = new int[maxLabel + 1];
            JArrays.fillIntProgression((int[])result, (int)0, (int)1);
            return result;
        }
        int[] map = new int[maxLabel + 1 - indexingBase];
        Arrays.fill(map, -1);
        IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)labels.length);
            for (i = block << 8; i < to; ++i) {
                int label = labels[i] - indexingBase;
                if (label < 0) continue;
                map[label] = 0;
            }
        });
        int count = indexingBase;
        for (int label = 0; label < map.length; ++label) {
            if (map[label] == -1) continue;
            map[label] = count++;
        }
        int[] restoringTable = includeReservedInRestoringTable ? ReindexLabels.buildRestoringTableWithReserved(map, count, indexingBase) : ReindexLabels.buildRestoringTableWithoutReserved(map, count, indexingBase);
        IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)labels.length);
            for (i = block << 8; i < to; ++i) {
                int label = labels[i] - indexingBase;
                if (label < 0) continue;
                labels[i] = map[label];
            }
        });
        return restoringTable;
    }

    private static int[] buildRestoringTableWithReserved(int[] map, int count, int indexingBase) {
        int[] restoringTable = new int[count];
        for (int reserved = 0; reserved < indexingBase; ++reserved) {
            restoringTable[reserved] = reserved;
        }
        for (int label = 0; label < map.length; ++label) {
            int newLabel = map[label];
            if (newLabel == -1) continue;
            restoringTable[newLabel] = indexingBase + label;
        }
        return restoringTable;
    }

    private static int[] buildRestoringTableWithoutReserved(int[] map, int count, int indexingBase) {
        int[] restoringTable = new int[count - indexingBase];
        for (int label = 0; label < map.length; ++label) {
            int newLabel = map[label];
            if (newLabel == -1) continue;
            restoringTable[newLabel - indexingBase] = indexingBase + label;
        }
        return restoringTable;
    }
}

