/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml;

import java.awt.Color;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.matrices.ml.training.MLTrainSVM;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_ml.SVM;
import org.bytedeco.opencv.opencv_ml.StatModel;
import org.bytedeco.opencv.opencv_ml.TrainData;

public final class SimpleColorClassifierTest {
    private static Mat toSamples(ColorLabel[] colorLabels) {
        Matrix m = Arrays.SMM.newFloatMatrix(new long[]{3L, colorLabels.length});
        float[] values = new float[3];
        int k = 0;
        int disp = 0;
        while (k < colorLabels.length) {
            ((UpdatableFloatArray)m.array()).setData((long)disp, (Object)colorLabels[k].color.getRGBColorComponents(values));
            ++k;
            disp += 3;
        }
        return O2SMat.toMat((MultiMatrix2D)MultiMatrix.valueOf2DMono((Matrix)m));
    }

    private static Mat toLabels(ColorLabel[] colorLabels) {
        Matrix m = Arrays.SMM.newIntMatrix(new long[]{1L, colorLabels.length});
        for (int k = 0; k < colorLabels.length; ++k) {
            ((UpdatablePNumberArray)m.array()).setInt((long)k, colorLabels[k].label);
        }
        return O2SMat.toMat((MultiMatrix2D)MultiMatrix.valueOf2DMono((Matrix)m));
    }

    private static void printSVM(SVM svm) {
        System.out.println("SVM: " + MLTrainSVM.toString((SVM)svm));
    }

    private static void printResponse(Mat mat) {
        MultiMatrix2D m = O2SMat.toMultiMatrix((Mat)mat);
        System.out.printf("%s%n", m);
        SNumbers numbers = SNumbers.valueOfArray((Object)m.channel(0).toJavaArray(), (int)((int)m.dim(0)));
        System.out.println(numbers.toString(true));
    }

    private static StatModel createSVM() {
        SVM result = SVM.create();
        SimpleColorClassifierTest.printSVM(result);
        return result;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.printf("Usage: %s some_file.xml%n", SimpleColorClassifierTest.class.getName());
            return;
        }
        String modelFile = args[0];
        StatModel classifier = SimpleColorClassifierTest.createSVM();
        ColorLabel[] colorLabels = new ColorLabel[]{new ColorLabel(Color.WHITE, 1), new ColorLabel(Color.WHITE, 1), new ColorLabel(new Color(250, 250, 250), 1), new ColorLabel(Color.BLACK, 2), new ColorLabel(new Color(1, 1, 1), 2), new ColorLabel(Color.YELLOW, 3)};
        TrainData trainData = TrainData.create((Mat)SimpleColorClassifierTest.toSamples(colorLabels), (int)0, (Mat)SimpleColorClassifierTest.toLabels(colorLabels));
        classifier.train(trainData);
        classifier.save(modelFile);
        SVM loadedClassifier = SVM.load((String)modelFile);
        colorLabels = new ColorLabel[]{new ColorLabel(new Color(255, 200, 255), 0), new ColorLabel(new Color(200, 200, 255), 0), new ColorLabel(new Color(1, 1, 1), 0), new ColorLabel(new Color(255, 200, 255), 0), new ColorLabel(new Color(0, 0, 0), 0), new ColorLabel(new Color(190, 210, 1), 0)};
        Mat result = new Mat();
        loadedClassifier.predict(SimpleColorClassifierTest.toSamples(colorLabels), result, 0);
        SimpleColorClassifierTest.printResponse(result);
    }

    static class ColorLabel {
        final Color color;
        final int label;

        public ColorLabel(Color color, int label) {
            this.color = color;
            this.label = label;
        }
    }
}

