/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SimpleUMatUsageTest {
    private static final Size KSIZE = new Size(55, 55);
    static final Tester SIMPLE_CLONING = source -> {
        UMat uMat = OTools.toUMat((Mat)source);
        SimpleUMatUsageTest.printMat("source", source);
        opencv_imgproc.GaussianBlur((UMat)uMat, (UMat)uMat, (Size)KSIZE, (double)0.0);
        SimpleUMatUsageTest.printMat("uMat", uMat);
        Mat result = OTools.toMat((UMat)uMat);
        SimpleUMatUsageTest.printMat("result", result);
        UMat uMatClone = OTools.toUMat((Mat)result);
        SimpleUMatUsageTest.printMat("uMat clone", uMatClone);
        uMatClone.close();
        return result;
    };
    static final Tester SIMPLE_CLOSING_DAMAGING_SOURCE = source -> {
        UMat uMat = source.getUMat(0x3000000);
        opencv_imgproc.GaussianBlur((UMat)uMat, (UMat)uMat, (Size)KSIZE, (double)0.0);
        return SimpleUMatUsageTest.toMatAndClose(uMat);
    };
    static final Tester THROUGH_BYTE_BUFFER = source -> {
        UMat uMat = OTools.toUMat((Mat)source);
        SimpleUMatUsageTest.printMat("source", source);
        opencv_imgproc.GaussianBlur((UMat)uMat, (UMat)uMat, (Size)KSIZE, (double)0.0);
        SimpleUMatUsageTest.printMat("uMat", uMat);
        ByteBuffer byteBuffer = OTools.toByteBuffer((UMat)uMat);
        Mat result = OTools.asMat((int)source.cols(), (int)source.rows(), (int)source.type(), (ByteBuffer)byteBuffer);
        SimpleUMatUsageTest.printMat("result", result);
        UMat uMatClone = OTools.toUMat((Mat)result);
        SimpleUMatUsageTest.printMat("uMat clone", uMatClone);
        uMatClone.close();
        return result;
    };
    static final Tester LOW_LEVEL_CRASHING = source -> {
        UMat uMat = source.getUMat(0x3000000);
        opencv_imgproc.GaussianBlur((UMat)uMat, (UMat)uMat, (Size)KSIZE, (double)0.0);
        Mat result = uMat.getMat(0x3000000);
        return result;
    };
    static final Tester LOW_LEVEL_IN_PLACE_ON_CLONE = source -> {
        UMat uMat = source.getUMat(0x3000000);
        SimpleUMatUsageTest.printMat("source", source);
        UMat uMatClone = uMat.clone();
        SimpleUMatUsageTest.printMat("uMat", uMat);
        opencv_imgproc.GaussianBlur((UMat)uMatClone, (UMat)uMatClone, (Size)KSIZE, (double)0.0);
        SimpleUMatUsageTest.printMat("uMatClone", uMatClone);
        Mat mat = uMatClone.getMat(0x3000000);
        SimpleUMatUsageTest.printMat("source", source);
        SimpleUMatUsageTest.printMat("mat", mat);
        Mat result = mat.clone();
        SimpleUMatUsageTest.printMat("result", result);
        mat.close();
        uMatClone.close();
        SimpleUMatUsageTest.printMat("uMat", uMat);
        SimpleUMatUsageTest.printMat("uMatClone", uMatClone);
        return result;
    };
    static final Tester LOW_LEVEL_IN_OTHER = source -> {
        UMat uMat = source.getUMat(0x3000000);
        SimpleUMatUsageTest.printMat("source", source);
        SimpleUMatUsageTest.printMat("uMat", uMat);
        UMat uResult = new UMat();
        opencv_imgproc.GaussianBlur((UMat)uMat, (UMat)uResult, (Size)KSIZE, (double)0.0);
        SimpleUMatUsageTest.printMat("uMat", uResult);
        Mat mat = uResult.getMat(0x3000000);
        SimpleUMatUsageTest.printMat("source", source);
        SimpleUMatUsageTest.printMat("mat", mat);
        Mat result = mat.clone();
        SimpleUMatUsageTest.printMat("result", result);
        mat.release();
        uResult.release();
        SimpleUMatUsageTest.printMat("uMat", uMat);
        return result;
    };
    private static final Tester TESTER = THROUGH_BYTE_BUFFER;

    public static Mat toMatAndClose(UMat u) {
        Mat m = u.getMat(0x3000000);
        try {
            Mat mat = m.clone();
            return mat;
        }
        finally {
            m.close();
            u.close();
        }
    }

    private static void printMat(String name, Mat mat) {
        System.out.printf("%-9s %s, address 0x%x (%d*%d bytes)%n", name + ":", mat, mat.address(), mat.limit(), mat.sizeof());
    }

    private static void printMat(String name, UMat mat) {
        System.out.printf("%-9s %s, address 0x%x, buffer %s%n", name + ":", OTools.toString((UMat)mat), mat.address(), mat.asByteBuffer());
    }

    public static void main(String[] args) throws FileNotFoundException, InterruptedException {
        int testCount;
        System.out.println("OpenCL existence: " + opencv_core.haveOpenCL());
        System.out.println("OpenCL usage: " + opencv_core.useOpenCL());
        System.out.println();
        if (args.length < 2) {
            System.out.printf("Usage: %s source_image target_image%n", SimpleUMatUsageTest.class.getName());
            return;
        }
        String sourceFile = args[0];
        String targetFile = args[1];
        if (!Files.exists(Paths.get(sourceFile, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(sourceFile);
        }
        Mat source = opencv_imgcodecs.imread((String)sourceFile);
        System.out.printf("Reading source image %s from %s%n", OTools.toString((Mat)source), sourceFile);
        Scalar zeroScalar = new Scalar(0.0, 0.0, 0.0, 0.0);
        for (testCount = 0; testCount < 10; ++testCount) {
            System.out.println("Performance test #" + testCount);
            double m = OTools.sizeOfInBytes((Mat)source);
            long t1 = System.nanoTime();
            Mat newMat = new Mat(source.rows(), source.cols(), source.type());
            long t2 = System.nanoTime();
            UMat newUMat = new UMat(source.rows(), source.cols(), source.type());
            long t3 = System.nanoTime();
            newMat = new Mat(source.rows(), source.cols(), source.type(), zeroScalar);
            long t4 = System.nanoTime();
            newUMat = new UMat(source.rows(), source.cols(), source.type(), zeroScalar);
            long t5 = System.nanoTime();
            newMat = Mat.zeros((int)source.rows(), (int)source.cols(), (int)source.type()).asMat();
            long t6 = System.nanoTime();
            newUMat = UMat.zeros((int)source.rows(), (int)source.cols(), (int)source.type());
            long t7 = System.nanoTime();
            Mat matClone = source.clone();
            long t8 = System.nanoTime();
            UMat getUMat = matClone.getUMat(0x3000000);
            long t9 = System.nanoTime();
            UMat toUMat = OTools.toUMat((Mat)source);
            long t10 = System.nanoTime();
            UMat uMatClone = getUMat.clone();
            long t11 = System.nanoTime();
            UMat toUMatClone = toUMat.clone();
            long t12 = System.nanoTime();
            Mat getMat = toUMat.getMat(0x3000000);
            long t13 = System.nanoTime();
            Mat toMat = OTools.toMat((UMat)toUMat);
            long t14 = System.nanoTime();
            ByteBuffer byteBuffer = OTools.toByteBuffer((UMat)uMatClone);
            long t15 = System.nanoTime();
            Mat toMatAndClose = SimpleUMatUsageTest.toMatAndClose(uMatClone);
            long t16 = System.nanoTime();
            getMat.close();
            long t17 = System.nanoTime();
            toUMat.close();
            long t18 = System.nanoTime();
            opencv_core.finish();
            long t19 = System.nanoTime();
            System.out.printf("new Mat:              %.3f mcs, %.2f ns/byte%n", (double)(t2 - t1) * 0.001, (double)(t2 - t1) / m);
            System.out.printf("new UMat:             %.3f mcs, %.2f ns/byte%n", (double)(t3 - t2) * 0.001, (double)(t3 - t2) / m);
            System.out.printf("new zero Mat:         %.3f mcs, %.2f ns/byte%n", (double)(t4 - t3) * 0.001, (double)(t4 - t3) / m);
            System.out.printf("new zero UMat:        %.3f mcs, %.2f ns/byte%n", (double)(t5 - t4) * 0.001, (double)(t5 - t4) / m);
            System.out.printf("Mat.zeros():          %.3f mcs, %.2f ns/byte%n", (double)(t6 - t5) * 0.001, (double)(t6 - t5) / m);
            System.out.printf("UMat.zeros():         %.3f mcs, %.2f ns/byte%n", (double)(t7 - t6) * 0.001, (double)(t7 - t6) / m);
            System.out.printf("Mat.clone():          %.3f mcs, %.2f ns/byte%n", (double)(t8 - t7) * 0.001, (double)(t8 - t7) / m);
            System.out.printf("Mat.getUMat():        %.3f mcs, %.2f ns/byte%n", (double)(t9 - t8) * 0.001, (double)(t9 - t8) / m);
            System.out.printf("toUMat():             %.3f mcs, %.2f ns/byte%n", (double)(t10 - t9) * 0.001, (double)(t10 - t9) / m);
            System.out.printf("(get)UMat.clone():    %.3f mcs, %.2f ns/byte%n", (double)(t11 - t10) * 0.001, (double)(t11 - t10) / m);
            System.out.printf("(new)UMat.clone():    %.3f mcs, %.2f ns/byte%n", (double)(t12 - t11) * 0.001, (double)(t12 - t11) / m);
            System.out.printf("UMat.getMat():        %.3f mcs, %.2f ns/byte%n", (double)(t13 - t12) * 0.001, (double)(t13 - t12) / m);
            System.out.printf("toMat():              %.3f mcs, %.2f ns/byte%n", (double)(t14 - t13) * 0.001, (double)(t14 - t13) / m);
            System.out.printf("toByteBuffer():       %.3f mcs, %.2f ns/byte%n", (double)(t15 - t14) * 0.001, (double)(t15 - t14) / m);
            System.out.printf("toMatAndClose():      %.3f mcs, %.2f ns/byte%n", (double)(t16 - t15) * 0.001, (double)(t16 - t15) / m);
            System.out.printf("Mat.close:()          %.3f mcs, %.2f ns/byte%n", (double)(t17 - t16) * 0.001, (double)(t17 - t16) / m);
            System.out.printf("UMat.close():         %.3f mcs, %.2f ns/byte%n", (double)(t18 - t17) * 0.001, (double)(t18 - t17) / m);
            System.out.printf("opencv_core.finish(): %.3f mcs, %.2f ns/byte%n", (double)(t19 - t18) * 0.001, (double)(t19 - t18) / m);
            System.out.println();
        }
        for (testCount = 0; testCount < 150; ++testCount) {
            System.out.println("Test #" + testCount);
            Mat result = TESTER.test(source);
            opencv_imgcodecs.imwrite((String)(targetFile + ".source.bmp"), (Mat)source);
            opencv_imgcodecs.imwrite((String)targetFile, (Mat)result);
            System.err.println("Start gc...");
            for (int k = 0; k < 10; ++k) {
                System.gc();
                Thread.sleep(5L);
            }
            System.err.println("End gc");
        }
    }

    static interface Tester {
        public Mat test(Mat var1);
    }
}

