/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.system.Chain;
import net.algart.executors.api.system.ChainBlock;
import net.algart.executors.api.system.ChainInputPort;
import net.algart.executors.api.system.ChainSpecification;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ExecutingChainDebugging {
    private static final String SESSION_ID = "~~DUMMY_SESSION";
    private static final boolean readUMat = false;

    public static void main(String[] args) throws IOException {
        Path chainFile = Paths.get(args[0], new String[0]);
        String sourceFile = args[1];
        int numberOfTests = 150;
        ExecutorFactory executorProvider = ExecutorFactory.newDefaultInstance((String)SESSION_ID);
        ChainSpecification chainJson = ChainSpecification.read((Path)chainFile);
        System.out.printf("Reading %s%n", chainFile);
        Chain chain = Chain.valueOf(null, (ExecutorFactory)executorProvider, (ChainSpecification)chainJson);
        chain.setMultithreading(true);
        chain.setExecuteAll(true);
        chain.reinitializeAll();
        SMat sourceMat = O2SMat.toSMat((Mat)opencv_imgcodecs.imread((String)sourceFile));
        System.out.printf("Reading source image %s%n", sourceFile);
        for (int test = 1; test <= 150; ++test) {
            System.out.printf("%nTest #%d/%d...%n", test, 150);
            for (ChainBlock block : chain.getAllInputs()) {
                ChainInputPort inputPort = block.reqStandardInputPort();
                String executorPortName = block.getStandardInputOutputName();
                if (!ExecutionBlock.DEFAULT_INPUT_PORT.equalsIgnoreCase(executorPortName) || inputPort.getDataType() != DataType.MAT) continue;
                inputPort.getData().setTo((Data)sourceMat, true);
                System.out.printf("Default input block initialized by the source image %s%n", sourceMat);
                break;
            }
            chain.execute();
            System.out.printf("Executed %d/%d blocks%n", chain.numberOfReadyBlocks(), chain.numberOfBlocks());
            chain.freeData();
            boolean haveOpenCL = opencv_core.haveOpenCL();
            boolean useOpenCL = opencv_core.useOpenCL();
            System.out.println((useOpenCL != haveOpenCL ? "!!! STRANGE SITUATION! " : "") + "haveOpenCL: " + haveOpenCL + "; useOpenCL: " + useOpenCL);
        }
    }
}

