/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.thresholds;

import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.cv.matrices.drawing.DrawRectangle;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.Percentile;
import net.algart.executors.modules.cv.matrices.morphology.RankMorphology;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.executors.modules.cv.matrices.objects.binary.components.FindConnectedWithMask;
import net.algart.executors.modules.cv.matrices.thresholds.SimpleThreshold;
import net.algart.executors.modules.opencv.matrices.filtering.GaussianBlur;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SmoothAreasThreshold
extends MultiMatrix2DFilter {
    public static final String INPUT_MASK = "mask";
    private int gaussianBlurKernelSize = 5;
    private int gradientDiameter = 5;
    private double gradientLevel = 1.0;
    private int medianDiameter = 0;
    private double threshold = 0.1;
    private boolean rawValue = false;
    private ResultType resultType = ResultType.SMOOTH_AREAS;
    private boolean borderAsDefaultMask = false;
    private boolean includeMaskInRetained = false;

    public SmoothAreasThreshold() {
        this.addInputMat(INPUT_MASK);
    }

    public int getGaussianBlurKernelSize() {
        return this.gaussianBlurKernelSize;
    }

    public SmoothAreasThreshold setGaussianBlurKernelSize(int gaussianBlurKernelSize) {
        this.gaussianBlurKernelSize = SmoothAreasThreshold.nonNegative((int)gaussianBlurKernelSize);
        return this;
    }

    public int getGradientDiameter() {
        return this.gradientDiameter;
    }

    public SmoothAreasThreshold setGradientDiameter(int gradientDiameter) {
        this.gradientDiameter = SmoothAreasThreshold.nonNegative((int)gradientDiameter);
        return this;
    }

    public double getGradientLevel() {
        return this.gradientLevel;
    }

    public SmoothAreasThreshold setGradientLevel(double gradientLevel) {
        this.gradientLevel = SmoothAreasThreshold.inRange((double)gradientLevel, (double)0.0, (double)1.0);
        return this;
    }

    public int getMedianDiameter() {
        return this.medianDiameter;
    }

    public SmoothAreasThreshold setMedianDiameter(int medianDiameter) {
        this.medianDiameter = SmoothAreasThreshold.nonNegative((int)medianDiameter);
        return this;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public SmoothAreasThreshold setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public boolean isRawValue() {
        return this.rawValue;
    }

    public SmoothAreasThreshold setRawValue(boolean rawValue) {
        this.rawValue = rawValue;
        return this;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public SmoothAreasThreshold setResultType(ResultType resultType) {
        this.resultType = (ResultType)((Object)SmoothAreasThreshold.nonNull((Object)((Object)resultType)));
        return this;
    }

    public boolean isBorderAsDefaultMask() {
        return this.borderAsDefaultMask;
    }

    public SmoothAreasThreshold setBorderAsDefaultMask(boolean borderAsDefaultMask) {
        this.borderAsDefaultMask = borderAsDefaultMask;
        return this;
    }

    public boolean isIncludeMaskInRetained() {
        return this.includeMaskInRetained;
    }

    public SmoothAreasThreshold setIncludeMaskInRetained(boolean includeMaskInRetained) {
        this.includeMaskInRetained = includeMaskInRetained;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        MultiMatrix2D mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        return this.process(source, mask);
    }

    public MultiMatrix2D process(MultiMatrix2D source, MultiMatrix2D mask) {
        source = source.toMonoIfNot();
        if (this.gaussianBlurKernelSize > 0) {
            source = GaussianBlur.blur(source, this.gaussianBlurKernelSize, true);
        }
        if (mask == null && this.borderAsDefaultMask) {
            DrawRectangle drawRectangle = new DrawRectangle();
            drawRectangle.setPercents(true).setLeft(0.0).setTop(0.0).setWidth(100.0).setHeight(100.0);
            drawRectangle.setThickness(1);
            drawRectangle.setClearSource(true);
            mask = drawRectangle.process(source.asPrecision(Boolean.TYPE));
        }
        StrictMorphology morphologyGradient = this.gradientLevel == 1.0 ? new StrictMorphology().setOperation(MorphologyOperation.BEUCHER_GRADIENT) : new RankMorphology().setOperation(MorphologyOperation.BEUCHER_GRADIENT).setLevel(this.gradientLevel);
        morphologyGradient.setPattern(MorphologyFilter.Shape.SPHERE, this.gradientDiameter);
        morphologyGradient.setContinuationMode(Matrix.ContinuationMode.MIRROR_CYCLIC);
        MultiMatrix2D gradient = morphologyGradient.process((MultiMatrix)source).asMultiMatrix2D();
        SimpleThreshold simpleThreshold = new SimpleThreshold();
        simpleThreshold.setMin(0.0);
        simpleThreshold.setMax(this.threshold);
        simpleThreshold.setRawValues(this.rawValue);
        MultiMatrix2D result = simpleThreshold.process(gradient);
        if (this.medianDiameter > 0) {
            Percentile morphologyMedian = new Percentile().setPercentile(0.5);
            morphologyMedian.setPattern(MorphologyFilter.Shape.SPHERE, this.medianDiameter);
            morphologyMedian.setContinuationMode(Matrix.ContinuationMode.MIRROR_CYCLIC);
            result = morphologyMedian.process((MultiMatrix)result).asMultiMatrix2D();
        }
        if (mask != null) {
            FindConnectedWithMask findConnectedWithMask = new FindConnectedWithMask();
            findConnectedWithMask.setMode(RetainOrRemoveMode.RETAIN);
            findConnectedWithMask.setIncludeMaskInRetained(this.includeMaskInRetained);
            result = findConnectedWithMask.process(new MultiMatrix2D[]{result, mask});
        }
        switch (this.resultType) {
            case EDGES_BETWEEN_AREAS: {
                return result.asFunc((Func)LinearFunc.getInstance((double)result.maxPossibleValue(), (double[])new double[]{-1.0})).clone();
            }
            case SMOOTH_AREAS: {
                return result;
            }
        }
        throw new AssertionError((Object)("Unknown " + this.resultType));
    }

    public static enum ResultType {
        SMOOTH_AREAS,
        EDGES_BETWEEN_AREAS;

    }
}

