/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.conversions;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.cv.matrices.objects.TableTranslate;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class LUT
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_TABLE = "table";
    public static final String OUTPUT_LABELS = "labels";
    private boolean castTo8U = false;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public LUT() {
        this.setDefaultInputMat("labels");
        this.addInputNumbers(INPUT_TABLE);
        this.setDefaultOutputMat("labels");
    }

    public boolean isCastTo8U() {
        return this.castTo8U;
    }

    public LUT setCastTo8U(boolean castTo8U) {
        this.castTo8U = castTo8U;
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public LUT setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)LUT.nonNull((Object)indexingBase);
        return this;
    }

    @Override
    public void process() {
        SNumbers lut = this.getInputNumbers(INPUT_TABLE).requireBlockLengthOne(INPUT_TABLE);
        if (lut.n() > 256 - this.indexingBase.start) {
            TableTranslate.ResultElementType resultElementType = lut.isFloatingPoint() ? TableTranslate.ResultElementType.FLOAT : TableTranslate.ResultElementType.INT;
            TableTranslate tableTranslate = new TableTranslate().setIndexingBase(IndexingBase.ZERO_BASED).setResultElementType(resultElementType);
            tableTranslate.putMat("labels", this.getInputMat("labels"));
            tableTranslate.putNumbers(INPUT_TABLE, lut);
            this.setStartProcessingTimeStamp();
            tableTranslate.process();
            this.setEndProcessingTimeStamp();
            this.getMat("labels").exchange((Data)tableTranslate.getMat("labels"));
            return;
        }
        super.process();
    }

    @Override
    public void process(Mat result, Mat source) {
        this.process(result, source, this.getInputNumbers(INPUT_TABLE).requireBlockLengthOne(INPUT_TABLE));
    }

    @Override
    public void process(UMat result, UMat source) {
        this.process(result, source, this.getInputNumbers(INPUT_TABLE).requireBlockLengthOne(INPUT_TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Mat result, Mat source, SNumbers translationTable) {
        try (Mat lut = O2SMat.numbersToMulticolumnMat(this.toLut256(translationTable));){
            Mat mat = source;
            try {
                if (this.castTo8U && mat.depth() != 0 && mat.depth() != 1) {
                    mat = new Mat();
                    source.convertTo(mat, 0);
                }
                opencv_core.LUT((Mat)mat, (Mat)lut, (Mat)result);
            }
            finally {
                OTools.closeFirstIfDiffersFromSecond(mat, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(UMat result, UMat source, SNumbers translationTable) {
        try (UMat lut = O2SMat.numbersToMulticolumnUMat(this.toLut256(translationTable));){
            UMat mat = source;
            try {
                if (this.castTo8U && mat.depth() != 0) {
                    mat = new UMat();
                    source.convertTo(mat, 0);
                }
                opencv_core.LUT((UMat)mat, (UMat)lut, (UMat)result);
            }
            finally {
                OTools.closeFirstIfDiffersFromSecond(mat, source);
            }
        }
    }

    private SNumbers toLut256(SNumbers lut) {
        SNumbers result = SNumbers.zeros((Class)lut.elementType(), (int)256, (int)1);
        int n = lut.n();
        for (int k = 0; k < 256; ++k) {
            int index = k - this.indexingBase.start;
            if (index < 0 || index >= n) {
                result.setValue(k, (double)k);
                continue;
            }
            result.setValue(k, lut.getValue(index, 0));
        }
        return result;
    }
}

