/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.IntArray;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat1Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat2Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat3Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat4Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat5Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsProcessor;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

public abstract class LabelledObjectsProcessorForFloat
extends LabelsProcessor {
    final int numberOfChannels;
    final int[] lists;
    final int[] listHeads;
    final SingleObjectProcessor processor;
    final float[][][] threadObjectData;
    private final float[][][] requestedObjectData;
    final int[] cardinalities;

    LabelledObjectsProcessorForFloat(int[] lists, int[] listHeads, SingleObjectProcessor processor, int numberOfChannels) {
        super((Array)IntArray.as((int[])Objects.requireNonNull(listHeads, "Null listHeads")), LabelledObjectsProcessorForFloat.numberOrParticlesInBlockForParallelProcessing(listHeads.length));
        this.numberOfChannels = numberOfChannels;
        this.lists = Objects.requireNonNull(lists, "Null lists");
        this.listHeads = listHeads;
        this.processor = Objects.requireNonNull(processor, "Null processor");
        this.requestedObjectData = LabelledObjectsProcessorForFloat.requestFloatArrays(this.numberOfTasks(), numberOfChannels);
        this.threadObjectData = new float[this.requestedObjectData.length][][];
        for (int k = 0; k < this.requestedObjectData.length; ++k) {
            this.threadObjectData[k] = (float[][])this.requestedObjectData[k].clone();
        }
        this.cardinalities = new int[Math.max(0, listHeads.length - 1)];
    }

    public static LabelledObjectsProcessorForFloat getInstance(int[] lists, int[] listHeads, SingleObjectProcessor processor, Object[] channels) {
        Objects.requireNonNull(lists, "Null lists");
        Objects.requireNonNull(listHeads, "Null listHeads");
        Objects.requireNonNull(processor, "Null processor");
        Objects.requireNonNull(channels, "Null channels");
        if (channels.length == 0) {
            throw new IllegalArgumentException("Empty channels array");
        }
        Object channel0 = channels[0];
        if (!LabelledObjectsProcessorForFloat.isArraySupported(channel0)) {
            throw new IllegalArgumentException("Illegal array type: " + channel0);
        }
        for (int k = 1; k < channels.length; ++k) {
            if (channels[k].getClass() == channel0.getClass()) continue;
            throw new IllegalArgumentException("Different type of channels: " + channels[k].getClass() + " != " + channel0.getClass());
        }
        switch (channels.length) {
            case 1: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessorForFloat1Channels.ForBytes(lists, listHeads, processor, (byte[])channel0);
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessorForFloat1Channels.ForShorts(lists, listHeads, processor, (short[])channel0);
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessorForFloat1Channels.ForInts(lists, listHeads, processor, (int[])channel0);
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessorForFloat1Channels.ForFloats(lists, listHeads, processor, (float[])channel0);
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessorForFloat1Channels.ForDoubles(lists, listHeads, processor, (double[])channel0);
                }
                throw new AssertionError();
            }
            case 2: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessorForFloat2Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessorForFloat2Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessorForFloat2Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessorForFloat2Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessorForFloat2Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 3: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessorForFloat3Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessorForFloat3Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessorForFloat3Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessorForFloat3Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessorForFloat3Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 4: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessorForFloat4Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessorForFloat4Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessorForFloat4Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessorForFloat4Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessorForFloat4Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 5: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessorForFloat5Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessorForFloat5Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessorForFloat5Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessorForFloat5Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessorForFloat5Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToDouble(channels));
                }
                throw new AssertionError();
            }
        }
        if (channel0 instanceof byte[]) {
            return new ForBytes(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToByte(channels));
        }
        if (channel0 instanceof short[]) {
            return new ForShorts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToShort(channels));
        }
        if (channel0 instanceof int[]) {
            return new ForInts(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToInt(channels));
        }
        if (channel0 instanceof float[]) {
            return new ForFloats(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToFloat(channels));
        }
        if (channel0 instanceof double[]) {
            return new ForDoubles(lists, listHeads, processor, LabelledObjectsProcessorForFloat.castToDouble(channels));
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        LabelledObjectsProcessorForFloat.releaseFloatArrays(this.requestedObjectData);
    }

    public int[] cardinalities() {
        return this.cardinalities;
    }

    private static class ForBytes
    extends LabelledObjectsProcessorForFloat {
        private final byte[][] data;

        ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index] & 0xFF;
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForShorts
    extends LabelledObjectsProcessorForFloat {
        private final short[][] data;

        ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index] & 0xFFFF;
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForInts
    extends LabelledObjectsProcessorForFloat {
        private final int[][] data;

        ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForFloats
    extends LabelledObjectsProcessorForFloat {
        private final float[][] data;

        ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForDoubles
    extends LabelledObjectsProcessorForFloat {
        private final double[][] data;

        ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = (float)this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

