/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

abstract class LabelledObjectsProcessor4Channels
extends LabelledObjectsProcessor {
    LabelledObjectsProcessor4Channels(int[] lists, int[] listHeads, SingleObjectProcessor processor) {
        super(lists, listHeads, processor, 4);
    }

    static class ForDoubles
    extends LabelledObjectsProcessor4Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;
        private final double[] data3;
        private final double[][][] threadObjectData;
        private final double[][][] requestedObjectData;

        public ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.requestedObjectData = ForDoubles.requestDoubleArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new double[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (double[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForDoubles.releaseDoubleArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            double[][] objectData = this.threadObjectData[threadIndex];
            double[] objectData0 = objectData[0];
            double[] objectData1 = objectData[1];
            double[] objectData2 = objectData[2];
            double[] objectData3 = objectData[3];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForFloats
    extends LabelledObjectsProcessor4Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;
        private final float[] data3;
        private final float[][][] threadObjectData;
        private final float[][][] requestedObjectData;

        public ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.requestedObjectData = ForFloats.requestFloatArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new float[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (float[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForFloats.releaseFloatArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForInts
    extends LabelledObjectsProcessor4Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;
        private final int[] data3;
        private final int[][][] threadObjectData;
        private final int[][][] requestedObjectData;

        public ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.requestedObjectData = ForInts.requestIntArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new int[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (int[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForInts.releaseIntArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            int[][] objectData = this.threadObjectData[threadIndex];
            int[] objectData0 = objectData[0];
            int[] objectData1 = objectData[1];
            int[] objectData2 = objectData[2];
            int[] objectData3 = objectData[3];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForShorts
    extends LabelledObjectsProcessor4Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;
        private final short[] data3;
        private final short[][][] threadObjectData;
        private final short[][][] requestedObjectData;

        public ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.requestedObjectData = ForShorts.requestShortArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new short[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (short[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForShorts.releaseShortArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            short[][] objectData = this.threadObjectData[threadIndex];
            short[] objectData0 = objectData[0];
            short[] objectData1 = objectData[1];
            short[] objectData2 = objectData[2];
            short[] objectData3 = objectData[3];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForBytes
    extends LabelledObjectsProcessor4Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;
        private final byte[] data3;
        private final byte[][][] threadObjectData;
        private final byte[][][] requestedObjectData;

        public ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.requestedObjectData = ForBytes.requestByteArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new byte[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (byte[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForBytes.releaseByteArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            byte[][] objectData = this.threadObjectData[threadIndex];
            byte[] objectData0 = objectData[0];
            byte[] objectData1 = objectData[1];
            byte[] objectData2 = objectData[2];
            byte[] objectData3 = objectData[3];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

