/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator;

abstract class CardinalitiesAndSumsOfSquaresCalculator1Channels
extends CardinalitiesAndSumsOfSquaresCalculator {
    CardinalitiesAndSumsOfSquaresCalculator1Channels(int[] labels) {
        super(labels, 1);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsOfSquaresCalculator1Channels {
        private final double[] data0;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sumsOfSquares0 = sumsOfSquares[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sumsOfSquares0[n3] = sumsOfSquares0[n3] + value0 * value0;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsOfSquaresCalculator1Channels {
        private final float[] data0;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sumsOfSquares0 = sumsOfSquares[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sumsOfSquares0[n3] = sumsOfSquares0[n3] + value0 * value0;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsOfSquaresCalculator1Channels {
        private final int[] data0;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sumsOfSquares0 = sumsOfSquares[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sumsOfSquares0[n3] = sumsOfSquares0[n3] + value0 * value0;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsOfSquaresCalculator1Channels {
        private final short[] data0;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sumsOfSquares0 = sumsOfSquares[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFFFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sumsOfSquares0[n3] = sumsOfSquares0[n3] + value0 * value0;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsOfSquaresCalculator1Channels {
        private final byte[] data0;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sumsOfSquares0 = sumsOfSquares[0];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sumsOfSquares0[n3] = sumsOfSquares0[n3] + value0 * value0;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

