/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class UnpackContours
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_UNPACKED_CONTOURS = "contours";
    private boolean needToProcessDiagonals = true;
    private boolean cacheLastContours = false;
    private volatile Contours lastPacked = null;
    private volatile Contours lastUnpacked = null;
    private final Object lock = new Object();

    public UnpackContours() {
        this.setDefaultInputNumbers("contours");
        this.setDefaultOutputNumbers("contours");
        this.addOutputScalar("number_of_objects");
    }

    public boolean isNeedToProcessDiagonals() {
        return this.needToProcessDiagonals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnpackContours setNeedToProcessDiagonals(boolean needToProcessDiagonals) {
        Object object = this.lock;
        synchronized (object) {
            if (needToProcessDiagonals != this.needToProcessDiagonals) {
                this.clearCache();
                this.needToProcessDiagonals = needToProcessDiagonals;
            }
        }
        return this;
    }

    public boolean isCacheLastContours() {
        return this.cacheLastContours;
    }

    public UnpackContours setCacheLastContours(boolean cacheLastContours) {
        this.cacheLastContours = cacheLastContours;
        return this;
    }

    public Contours unpackContours(int[] array) {
        return this.cacheLastContours ? this.unpackContoursWithCaching(array) : this.unpackContoursWithoutCaching(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contours unpackContoursWithCaching(int[] serializedContours) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastPacked == null || !this.lastPacked.equalsToSerialized(serializedContours)) {
                Contours contours;
                this.lastPacked = contours = Contours.deserialize((int[])serializedContours);
                this.lastUnpacked = this.unpackContoursWithoutCaching(contours);
            }
            return this.lastUnpacked;
        }
    }

    public Contours unpackContoursWithoutCaching(int[] serializedContours) {
        return this.unpackContoursWithoutCaching(Contours.deserialize((int[])serializedContours));
    }

    public Contours unpackContours(Contours contours) {
        return this.cacheLastContours ? this.unpackContoursWithCaching(contours) : this.unpackContoursWithoutCaching(contours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contours unpackContoursWithCaching(Contours contours) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastPacked == null || !this.lastPacked.equals((Object)contours)) {
                this.lastPacked = contours;
                this.lastUnpacked = this.unpackContoursWithoutCaching(contours);
            }
            return this.lastUnpacked;
        }
    }

    public Contours unpackContoursWithoutCaching(Contours contours) {
        return contours.unpackContours(this.needToProcessDiagonals);
    }

    protected SNumbers processNumbers(SNumbers source) {
        int[] array = source.toIntArrayOrReference();
        this.setStartProcessingTimeStamp();
        long t1 = UnpackContours.debugTime();
        Contours result = this.unpackContours(array);
        long t2 = UnpackContours.debugTime();
        this.setEndProcessingTimeStamp();
        UnpackContours.logDebug(() -> String.format(Locale.US, "%d contours unpacked in %.3f ms", result.numberOfContours(), (double)(t2 - t1) * 1.0E-6));
        this.getScalar("number_of_objects").setTo(result.numberOfContours());
        return SNumbers.valueOf((Contours)result);
    }

    private void clearCache() {
        this.lastPacked = null;
        this.lastUnpacked = null;
    }
}

