/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.slopes;

import java.util.Objects;

public final class SlopeEmphasizer {
    private double minimalChange = 0.0;
    private long minimalChangeLong = 0L;
    private int slopeWidth = 1;
    private boolean allowLongSlopes = true;
    private boolean processAscending = true;
    private boolean processDescending = true;
    private boolean exactHalfSum = true;
    private int exactHalfSum01 = 1;

    private SlopeEmphasizer() {
    }

    public static SlopeEmphasizer getInstance() {
        return new SlopeEmphasizer();
    }

    public ForType forElementType(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (elementType == Byte.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int offset, int count) {
                    SlopeEmphasizer.this.emphasize((byte[])values, offset, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((byte[])values, offset, count, step);
                }
            };
        }
        if (elementType == Short.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int offset, int count) {
                    SlopeEmphasizer.this.emphasize((short[])values, offset, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((short[])values, offset, count, step);
                }
            };
        }
        if (elementType == Integer.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int offset, int count) {
                    SlopeEmphasizer.this.emphasize((int[])values, offset, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((int[])values, offset, count, step);
                }
            };
        }
        if (elementType == Long.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int offset, int count) {
                    SlopeEmphasizer.this.emphasize((long[])values, offset, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((long[])values, offset, count, step);
                }
            };
        }
        if (elementType == Float.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int offset, int count) {
                    SlopeEmphasizer.this.emphasize((float[])values, offset, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((float[])values, offset, count, step);
                }
            };
        }
        if (elementType == Double.TYPE) {
            return new ForType(){

                @Override
                public void emphasize(Object values, int from, int count) {
                    SlopeEmphasizer.this.emphasize((double[])values, from, count);
                }

                @Override
                public void emphasize(Object values, int offset, int count, int step) {
                    SlopeEmphasizer.this.emphasize((double[])values, offset, count, step);
                }
            };
        }
        throw new IllegalArgumentException("The element type " + elementType + " is not supported");
    }

    public double getMinimalChange() {
        return this.minimalChange;
    }

    public SlopeEmphasizer setMinimalChange(double minimalChange) {
        if (minimalChange < 0.0) {
            throw new IllegalArgumentException("Negative minimalChange = " + minimalChange);
        }
        this.minimalChange = minimalChange;
        this.minimalChangeLong = (long)minimalChange;
        return this;
    }

    public int getSlopeWidth() {
        return this.slopeWidth;
    }

    public SlopeEmphasizer setSlopeWidth(int slopeWidth) {
        if (slopeWidth <= 0) {
            throw new IllegalArgumentException("Zero or negative slopeWidth = " + slopeWidth);
        }
        this.slopeWidth = slopeWidth;
        return this;
    }

    public boolean isAllowLongSlopes() {
        return this.allowLongSlopes;
    }

    public SlopeEmphasizer setAllowLongSlopes(boolean allowLongSlopes) {
        this.allowLongSlopes = allowLongSlopes;
        return this;
    }

    public boolean isProcessAscending() {
        return this.processAscending;
    }

    public SlopeEmphasizer setProcessAscending(boolean processAscending) {
        this.processAscending = processAscending;
        return this;
    }

    public boolean isProcessDescending() {
        return this.processDescending;
    }

    public SlopeEmphasizer setProcessDescending(boolean processDescending) {
        this.processDescending = processDescending;
        return this;
    }

    public boolean isExactHalfSum() {
        return this.exactHalfSum;
    }

    public SlopeEmphasizer setExactHalfSum(boolean exactHalfSum) {
        this.exactHalfSum = exactHalfSum;
        this.exactHalfSum01 = exactHalfSum ? 1 : 0;
        return this;
    }

    public void emphasize(byte[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(byte[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        byte left = values[p];
        while (++p < last) {
            byte right;
            byte v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if ((v & 0xFF) > (left & 0xFF)) {
                ++q;
                while (q <= last && ((probe = values[q]) & 0xFF) > (v & 0xFF)) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last && ((probe = values[q]) & 0xFF) < (v & 0xFF)) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(byte[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        byte left = values[p];
        while ((p += step) >= 0 && p < last) {
            byte right;
            byte v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if ((v & 0xFF) > (left & 0xFF)) {
                q += step;
                while (q >= 0 && q <= last && ((probe = values[q]) & 0xFF) > (v & 0xFF)) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last && ((probe = values[q]) & 0xFF) < (v & 0xFF)) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(char[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(char[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        char left = values[p];
        while (++p < last) {
            char right;
            char v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if (v > left) {
                ++q;
                while (q <= last && (probe = values[q]) > v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last && (probe = values[q]) < v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(char[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        char left = values[p];
        while ((p += step) >= 0 && p < last) {
            char right;
            char v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if (v > left) {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) > v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) < v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(short[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(short[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        short left = values[p];
        while (++p < last) {
            short right;
            short v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if ((v & 0xFFFF) > (left & 0xFFFF)) {
                ++q;
                while (q <= last && ((probe = values[q]) & 0xFFFF) > (v & 0xFFFF)) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last && ((probe = values[q]) & 0xFFFF) < (v & 0xFFFF)) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(short[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        short left = values[p];
        while ((p += step) >= 0 && p < last) {
            short right;
            short v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if ((v & 0xFFFF) > (left & 0xFFFF)) {
                q += step;
                while (q >= 0 && q <= last && ((probe = values[q]) & 0xFFFF) > (v & 0xFFFF)) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last && ((probe = values[q]) & 0xFFFF) < (v & 0xFFFF)) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(int[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(int[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        int left = values[p];
        while (++p < last) {
            int right;
            int v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if (v > left) {
                ++q;
                while (q <= last && (probe = values[q]) > v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last && (probe = values[q]) < v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(int[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        int left = values[p];
        while ((p += step) >= 0 && p < last) {
            int right;
            int v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if (v > left) {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) > v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) < v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(long[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(long[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        long left = values[p];
        while (++p < last) {
            long right;
            long v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if (v > left) {
                ++q;
                while (q <= last && (probe = values[q]) > v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last && (probe = values[q]) < v) {
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(long[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        long left = values[p];
        while ((p += step) >= 0 && p < last) {
            long right;
            long v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if (v > left) {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) > v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last && (probe = values[q]) < v) {
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(float[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(float[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        float left = values[p];
        while (++p < last) {
            float right;
            float v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if (v > left) {
                ++q;
                while (q <= last) {
                    float f;
                    probe = values[q];
                    if (!(f > v)) break;
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last) {
                    float f;
                    probe = values[q];
                    if (!(f < v)) break;
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(float[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        float left = values[p];
        while ((p += step) >= 0 && p < last) {
            float right;
            float v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if (v > left) {
                q += step;
                while (q >= 0 && q <= last) {
                    float f;
                    probe = values[q];
                    if (!(f > v)) break;
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last) {
                    float f;
                    probe = values[q];
                    if (!(f < v)) break;
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(double[] values) {
        this.emphasize(values, 0, values.length);
    }

    public void emphasize(double[] values, int offset, int count) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        int last = offset + count - 1;
        if (last < 0 || last >= values.length) {
            throw new IndexOutOfBoundsException("Last position " + ((long)offset + (long)count - 1L) + " >= array length (" + values.length + ")");
        }
        int p = offset;
        double left = values[p];
        while (++p < last) {
            double right;
            double v = values[p];
            if (v == left) continue;
            int q = p--;
            assert (values[p] == left);
            assert (values[q] == v);
            if (v > left) {
                ++q;
                while (q <= last) {
                    double d;
                    probe = values[q];
                    if (!(d > v)) break;
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right);
                }
            } else {
                ++q;
                while (q <= last) {
                    double d;
                    probe = values[q];
                    if (!(d < v)) break;
                    v = probe;
                    ++q;
                }
                --q;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    public void emphasize(double[] values, int offset, int count, int step) {
        Objects.requireNonNull(values, "Null values");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start position " + offset + " < 0");
        }
        if (step <= 0) {
            throw new IndexOutOfBoundsException("Zero or negative step = " + step);
        }
        if (count == 0 || !this.processAscending && !this.processDescending) {
            return;
        }
        long longLast = (long)offset + (long)step * ((long)count - 1L);
        if (longLast >= (long)values.length) {
            throw new IndexOutOfBoundsException("Last position " + longLast + " >= array length (" + values.length + ")");
        }
        int last = (int)longLast;
        int slopeDistance = (int)Math.min((long)(this.slopeWidth - 1) * (long)step, Integer.MAX_VALUE);
        int p = offset;
        double left = values[p];
        while ((p += step) >= 0 && p < last) {
            double right;
            double v = values[p];
            if (v == left) continue;
            int q = p;
            assert (values[p -= step] == left);
            assert (values[q] == v);
            if (v > left) {
                q += step;
                while (q >= 0 && q <= last) {
                    double d;
                    probe = values[q];
                    if (!(d > v)) break;
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processAscending && this.differenceEnough(left, right)) {
                    this.analyzeAscendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            } else {
                q += step;
                while (q >= 0 && q <= last) {
                    double d;
                    probe = values[q];
                    if (!(d < v)) break;
                    v = probe;
                    q += step;
                }
                q -= step;
                right = v;
                if (this.processDescending && this.differenceEnough(right, left)) {
                    this.analyzeDescendingSlope(values, p, q, left, right, step, slopeDistance);
                }
            }
            assert (values[q] == right);
            left = right;
            p = q;
        }
        return;
    }

    private void analyzeAscendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue) {
        assert (first < last);
        assert ((leftValue & 0xFF) < (rightValue & 0xFF));
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        byte left = leftValue;
        byte right = values[q];
        while (true) {
            byte probeRight;
            int probeQ;
            byte probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue, int step, int d) {
        assert (first < last);
        assert ((leftValue & 0xFF) < (rightValue & 0xFF));
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        byte left = leftValue;
        byte right = values[q];
        while (true) {
            byte probeRight;
            int probeQ;
            byte probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue) {
        assert (first < last);
        assert ((leftValue & 0xFF) > (rightValue & 0xFF));
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        byte left = leftValue;
        byte right = values[q];
        while (true) {
            byte probeLeft;
            int probeQ;
            byte probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue, int step, int d) {
        assert (first < last);
        assert ((leftValue & 0xFF) > (rightValue & 0xFF));
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        byte left = leftValue;
        byte right = values[q];
        while (true) {
            byte probeLeft;
            int probeQ;
            byte probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && (values[p] & 0xFF) < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && (values[p] & 0xFF) < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && (values[p] & 0xFF) > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(byte[] values, int first, int last, byte leftValue, byte rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && (values[p] & 0xFF) > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(char[] values, int first, int last, char leftValue, char rightValue) {
        assert (first < last);
        assert (leftValue < rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        char left = leftValue;
        char right = values[q];
        while (true) {
            char probeRight;
            int probeQ;
            char probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(char[] values, int first, int last, char leftValue, char rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue < rightValue);
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        char left = leftValue;
        char right = values[q];
        while (true) {
            char probeRight;
            int probeQ;
            char probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(char[] values, int first, int last, char leftValue, char rightValue) {
        assert (first < last);
        assert (leftValue > rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        char left = leftValue;
        char right = values[q];
        while (true) {
            char probeLeft;
            int probeQ;
            char probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(char[] values, int first, int last, char leftValue, char rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue > rightValue);
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        char left = leftValue;
        char right = values[q];
        while (true) {
            char probeLeft;
            int probeQ;
            char probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(char[] values, int first, int last, char leftValue, char rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && values[p] < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(char[] values, int first, int last, char leftValue, char rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && values[p] < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(char[] values, int first, int last, char leftValue, char rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && values[p] > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(char[] values, int first, int last, char leftValue, char rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && values[p] > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(short[] values, int first, int last, short leftValue, short rightValue) {
        assert (first < last);
        assert ((leftValue & 0xFFFF) < (rightValue & 0xFFFF));
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        short left = leftValue;
        short right = values[q];
        while (true) {
            short probeRight;
            int probeQ;
            short probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(short[] values, int first, int last, short leftValue, short rightValue, int step, int d) {
        assert (first < last);
        assert ((leftValue & 0xFFFF) < (rightValue & 0xFFFF));
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        short left = leftValue;
        short right = values[q];
        while (true) {
            short probeRight;
            int probeQ;
            short probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(short[] values, int first, int last, short leftValue, short rightValue) {
        assert (first < last);
        assert ((leftValue & 0xFFFF) > (rightValue & 0xFFFF));
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        short left = leftValue;
        short right = values[q];
        while (true) {
            short probeLeft;
            int probeQ;
            short probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(short[] values, int first, int last, short leftValue, short rightValue, int step, int d) {
        assert (first < last);
        assert ((leftValue & 0xFFFF) > (rightValue & 0xFFFF));
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        short left = leftValue;
        short right = values[q];
        while (true) {
            short probeLeft;
            int probeQ;
            short probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(short[] values, int first, int last, short leftValue, short rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && (values[p] & 0xFFFF) < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(short[] values, int first, int last, short leftValue, short rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && (values[p] & 0xFFFF) < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(short[] values, int first, int last, short leftValue, short rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && (values[p] & 0xFFFF) > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(short[] values, int first, int last, short leftValue, short rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && (values[p] & 0xFFFF) > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(int[] values, int first, int last, int leftValue, int rightValue) {
        assert (first < last);
        assert (leftValue < rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        int left = leftValue;
        int right = values[q];
        while (true) {
            int probeRight;
            int probeQ;
            int probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(int[] values, int first, int last, int leftValue, int rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue < rightValue);
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        int left = leftValue;
        int right = values[q];
        while (true) {
            int probeRight;
            int probeQ;
            int probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(int[] values, int first, int last, int leftValue, int rightValue) {
        assert (first < last);
        assert (leftValue > rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        int left = leftValue;
        int right = values[q];
        while (true) {
            int probeLeft;
            int probeQ;
            int probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(int[] values, int first, int last, int leftValue, int rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue > rightValue);
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        int left = leftValue;
        int right = values[q];
        while (true) {
            int probeLeft;
            int probeQ;
            int probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(int[] values, int first, int last, int leftValue, int rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && values[p] < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(int[] values, int first, int last, int leftValue, int rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && values[p] < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(int[] values, int first, int last, int leftValue, int rightValue) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && values[p] > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(int[] values, int first, int last, int leftValue, int rightValue, int step) {
        int p;
        assert (first < last);
        int halfSum = this.halfSumFloor(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && values[p] > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(long[] values, int first, int last, long leftValue, long rightValue) {
        assert (first < last);
        assert (leftValue < rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        long left = leftValue;
        long right = values[q];
        while (true) {
            long probeRight;
            int probeQ;
            long probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(long[] values, int first, int last, long leftValue, long rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue < rightValue);
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        long left = leftValue;
        long right = values[q];
        while (true) {
            long probeRight;
            int probeQ;
            long probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(long[] values, int first, int last, long leftValue, long rightValue) {
        assert (first < last);
        assert (leftValue > rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        long left = leftValue;
        long right = values[q];
        while (true) {
            long probeLeft;
            int probeQ;
            long probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(long[] values, int first, int last, long leftValue, long rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue > rightValue);
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        long left = leftValue;
        long right = values[q];
        while (true) {
            long probeLeft;
            int probeQ;
            long probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(long[] values, int first, int last, long leftValue, long rightValue) {
        int p;
        assert (first < last);
        long halfSum = this.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && values[p] < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(long[] values, int first, int last, long leftValue, long rightValue, int step) {
        int p;
        assert (first < last);
        long halfSum = this.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && values[p] < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(long[] values, int first, int last, long leftValue, long rightValue) {
        int p;
        assert (first < last);
        long halfSum = this.halfSumFloor(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && values[p] > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(long[] values, int first, int last, long leftValue, long rightValue, int step) {
        int p;
        assert (first < last);
        long halfSum = this.halfSumFloor(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && values[p] > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(float[] values, int first, int last, float leftValue, float rightValue) {
        assert (first < last);
        assert (leftValue < rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        float left = leftValue;
        float right = values[q];
        while (true) {
            float probeRight;
            int probeQ;
            float probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(float[] values, int first, int last, float leftValue, float rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue < rightValue);
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        float left = leftValue;
        float right = values[q];
        while (true) {
            float probeRight;
            int probeQ;
            float probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(float[] values, int first, int last, float leftValue, float rightValue) {
        assert (first < last);
        assert (leftValue > rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        float left = leftValue;
        float right = values[q];
        while (true) {
            float probeLeft;
            int probeQ;
            float probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(float[] values, int first, int last, float leftValue, float rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue > rightValue);
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        float left = leftValue;
        float right = values[q];
        while (true) {
            float probeLeft;
            int probeQ;
            float probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(float[] values, int first, int last, float leftValue, float rightValue) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && (double)values[p] < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(float[] values, int first, int last, float leftValue, float rightValue, int step) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && (double)values[p] < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(float[] values, int first, int last, float leftValue, float rightValue) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && (double)values[p] > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(float[] values, int first, int last, float leftValue, float rightValue, int step) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && (double)values[p] > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void analyzeAscendingSlope(double[] values, int first, int last, double leftValue, double rightValue) {
        assert (first < last);
        assert (leftValue < rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        double left = leftValue;
        double right = values[q];
        while (true) {
            double probeRight;
            int probeQ;
            double probeLeft;
            if (!this.differenceEnough(left, right)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + 1) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeAscendingSlope(double[] values, int first, int last, double leftValue, double rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue < rightValue);
        assert (d >= 0);
        if (last - first <= d) {
            this.fillAscendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        double left = leftValue;
        double right = values[q];
        while (true) {
            double probeRight;
            int probeQ;
            double probeLeft;
            if (!this.differenceEnough(left, right)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeLeft = values[(probeQ = q + step) - d], probeRight = values[probeQ])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillAscendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(double[] values, int first, int last, double leftValue, double rightValue) {
        assert (first < last);
        assert (leftValue > rightValue);
        int d = this.slopeWidth - 1;
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue);
            return;
        }
        int lastMinus1 = last - 1;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        double left = leftValue;
        double right = values[q];
        while (true) {
            double probeLeft;
            int probeQ;
            double probeRight;
            if (!this.differenceEnough(right, left)) {
                ++p;
                if (++q > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + 1], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right);
            if (q >= lastMinus1) {
                return;
            }
            p = (q += 2) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void analyzeDescendingSlope(double[] values, int first, int last, double leftValue, double rightValue, int step, int d) {
        assert (first < last);
        assert (leftValue > rightValue);
        assert (d >= 0) : "invalid slopeWidth = " + this.slopeWidth;
        if (last - first <= d) {
            this.fillDescendingSlope(values, first, last, leftValue, rightValue, step);
            return;
        }
        int lastMinusStep = last - step;
        int doubleStep = step * 2;
        int p = first;
        int q = first + d;
        if (!this.allowLongSlopes) {
            return;
        }
        double left = leftValue;
        double right = values[q];
        while (true) {
            double probeLeft;
            int probeQ;
            double probeRight;
            if (!this.differenceEnough(right, left)) {
                p += step;
                if ((q += step) > last) {
                    return;
                }
                left = values[p];
                right = values[q];
                continue;
            }
            while (q < last && this.differenceEnough(probeRight = values[probeQ = q + step], probeLeft = values[probeQ - d])) {
                q = probeQ;
                right = probeRight;
            }
            this.fillDescendingSlope(values, p, q, left, right, step);
            if (q >= lastMinusStep) {
                return;
            }
            p = (q += doubleStep) - d;
            left = values[p];
            right = values[q];
        }
    }

    private void fillAscendingSlope(double[] values, int first, int last, double leftValue, double rightValue) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(leftValue, rightValue);
        --last;
        for (p = ++first; p <= last && values[p] < halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillAscendingSlope(double[] values, int first, int last, double leftValue, double rightValue, int step) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(leftValue, rightValue);
        last -= step;
        for (p = first += step; p <= last && values[p] < halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private void fillDescendingSlope(double[] values, int first, int last, double leftValue, double rightValue) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(rightValue, leftValue);
        --last;
        for (p = ++first; p <= last && values[p] > halfSum; ++p) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            ++p;
        }
    }

    private void fillDescendingSlope(double[] values, int first, int last, double leftValue, double rightValue, int step) {
        int p;
        assert (first < last);
        double halfSum = SlopeEmphasizer.halfSum(rightValue, leftValue);
        last -= step;
        for (p = first += step; p <= last && values[p] > halfSum; p += step) {
            values[p] = leftValue;
        }
        while (p <= last) {
            values[p] = rightValue;
            p += step;
        }
    }

    private boolean differenceEnough(byte less, byte greater) {
        return (long)((greater & 0xFF) - (less & 0xFF)) >= this.minimalChangeLong;
    }

    private boolean differenceEnough(char less, char greater) {
        return (long)(greater - less) >= this.minimalChangeLong;
    }

    private boolean differenceEnough(short less, short greater) {
        return (long)((greater & 0xFFFF) - (less & 0xFFFF)) >= this.minimalChangeLong;
    }

    private boolean differenceEnough(int less, int greater) {
        return (long)greater - (long)less >= this.minimalChangeLong;
    }

    private boolean differenceEnough(long less, long greater) {
        long difference = greater - less;
        return difference < 0L || difference >= this.minimalChangeLong;
    }

    private boolean differenceEnough(float less, float greater) {
        return (double)greater - (double)less >= this.minimalChange;
    }

    private boolean differenceEnough(double less, double greater) {
        return greater - less >= this.minimalChange;
    }

    private int halfSum(byte less, byte greater) {
        return (less & 0xFF) + (greater & 0xFF) + this.exactHalfSum01 >>> 1;
    }

    private int halfSum(char less, char greater) {
        return less + greater + this.exactHalfSum01 >>> 1;
    }

    private int halfSum(short less, short greater) {
        return (less & 0xFFFF) + (greater & 0xFFFF) + this.exactHalfSum01 >>> 1;
    }

    private int halfSum(int less, int greater) {
        assert (less <= greater);
        return less + (greater - less >>> 1) + ((greater ^ less) & this.exactHalfSum01);
    }

    private long halfSum(long less, long greater) {
        assert (less <= greater);
        return less + (greater - less >>> 1) + ((greater ^ less) & (long)this.exactHalfSum01);
    }

    private int halfSumFloor(byte less, byte greater) {
        return (less & 0xFF) + (greater & 0xFF) >>> 1;
    }

    private int halfSumFloor(char less, char greater) {
        return less + greater >>> 1;
    }

    private int halfSumFloor(short less, short greater) {
        return (less & 0xFFFF) + (greater & 0xFFFF) >>> 1;
    }

    private int halfSumFloor(int less, int greater) {
        assert (less <= greater);
        return less + (greater - less >>> 1);
    }

    private long halfSumFloor(long less, long greater) {
        assert (less <= greater);
        return less + (greater - less >>> 1);
    }

    private static double halfSum(float less, float greater) {
        return 0.5 * ((double)less + (double)greater);
    }

    private static double halfSum(double less, double greater) {
        return 0.5 * (less + greater);
    }

    public static interface ForType {
        public void emphasize(Object var1, int var2, int var3);

        public void emphasize(Object var1, int var2, int var3, int var4);
    }
}

