/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml.training;

import net.algart.executors.modules.opencv.matrices.ml.AbstractMLTrain;
import net.algart.executors.modules.opencv.matrices.ml.MLKind;
import net.algart.executors.modules.opencv.matrices.ml.MLSamplesType;
import net.algart.executors.modules.opencv.matrices.ml.MLStatModelTrainer;
import org.bytedeco.opencv.opencv_ml.NormalBayesClassifier;
import org.bytedeco.opencv.opencv_ml.StatModel;

public final class MLTrainNormalBayesClassifier
extends AbstractMLTrain {
    private MLTrainNormalBayesClassifier(MLSamplesType inputType) {
        super(inputType);
    }

    public static MLTrainNormalBayesClassifier newTrainNumbers() {
        return new MLTrainNormalBayesClassifier(MLSamplesType.NUMBERS);
    }

    public static MLTrainNormalBayesClassifier newTrainPixels() {
        return new MLTrainNormalBayesClassifier(MLSamplesType.PIXELS);
    }

    public void process() {
        try (NormalBayesClassifier model = this.newStatModel();){
            MLTrainNormalBayesClassifier.logDebug(() -> "Training NormalBayesClassifier");
            MLStatModelTrainer trainer = new MLStatModelTrainer((StatModel)model, this.modelKind());
            this.setTrainingFlags(trainer);
            this.train(trainer);
            this.writeTrainer(trainer);
        }
    }

    @Override
    protected MLKind modelKind() {
        return MLKind.StatModelBased.NORMAL_BAYES_CLASSIFIER;
    }

    @Override
    protected boolean categoricalResponses() {
        return true;
    }

    private NormalBayesClassifier newStatModel() {
        return NormalBayesClassifier.create();
    }
}

