/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.io;

import java.io.IOError;
import java.io.IOException;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ReadMat
extends FileOperation
implements ReadOnlyExecutionInput {
    public ReadMat() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public static ReadMat getSecureInstance() {
        ReadMat result = new ReadMat();
        result.setSecure(true);
        return result;
    }

    public ReadMat setFile(String file) {
        super.setFile(file);
        return this;
    }

    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadMat.logDebug(() -> "Copying " + input);
            this.getMat().setTo(input);
        } else {
            this.readMat(this.getMat());
        }
    }

    public SMat readMat() {
        return this.readMat(new SMat());
    }

    public SMat readMat(SMat result) {
        String file = this.completeFilePath().toAbsolutePath().toString();
        ReadMat.logDebug(() -> "Reading OpenCV matrix from " + file);
        Mat mat = opencv_imgcodecs.imread((String)file);
        if (mat == null || mat.data() == null) {
            throw new IOError(new IOException("Cannot read " + file));
        }
        O2SMat.setTo(result, mat);
        return result;
    }
}

