/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import net.algart.arrays.DoubleArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.cv.matrices.morphology.RankMorphologyFilter;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.RankMorphology;

public final class TruncatedMean
extends RankMorphologyFilter {
    private double lowLimit = 0.1;
    private double highLimit = 0.9;
    private LimitInterpretation limitInterpretation = LimitInterpretation.NORMALIZED_0_1_PERCENTILE;
    private double[] fillerColor = new double[3];

    public double getLowLimit() {
        return this.lowLimit;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = TruncatedMean.inRange((double)lowLimit, (double)0.0, (double)1.0);
    }

    public double getHighLimit() {
        return this.highLimit;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = TruncatedMean.inRange((double)highLimit, (double)0.0, (double)1.0);
    }

    public LimitInterpretation getLimitInterpretation() {
        return this.limitInterpretation;
    }

    public void setLimitInterpretation(LimitInterpretation limitInterpretation) {
        this.limitInterpretation = (LimitInterpretation)((Object)TruncatedMean.nonNull((Object)((Object)limitInterpretation)));
    }

    public double[] getFillerColor() {
        return (double[])this.fillerColor.clone();
    }

    public void setFillerColor(double[] fillerColor) {
        TruncatedMean.nonNull((Object)fillerColor);
        this.fillerColor = new double[4];
        System.arraycopy(fillerColor, 0, this.fillerColor, 0, Math.min(fillerColor.length, 3));
    }

    public void setFillerColor(String fillerColor) {
        TruncatedMean.nonNull((Object)fillerColor);
        this.setFillerColor(ChannelOperation.decodeRGBA((String)fillerColor));
    }

    @Override
    protected Matrix<? extends PArray> processCompressedChannel(Matrix<? extends PArray> m) {
        Pattern pattern = this.getPattern(m);
        if (this.currentChannel() == 0) {
            TruncatedMean.logDebug(() -> "Truncated mean in " + this.lowLimit + ".." + this.highLimit + (this.limitInterpretation == LimitInterpretation.NORMALIZED_0_1_PERCENTILE ? "percentile" : "value") + " range" + this.rankMorphologyLogMessage() + " with " + pattern + (String)(this.continuationMode == null ? "" : ", " + this.continuationMode) + " for " + this.sourceMultiMatrix());
        }
        double scale = ((PArray)m.array()).maxPossibleValue(1.0);
        double filler = scale * this.colorChannel(this.fillerColor);
        RankMorphology morphology = this.createRankMorphology(m.elementType(), 1.0);
        switch (this.limitInterpretation) {
            case NORMALIZED_0_1_PERCENTILE: {
                double fromPercentile = this.lowLimit * (double)pattern.pointCount();
                double toPercentile = this.highLimit * (double)pattern.pointCount();
                return morphology.meanBetweenPercentiles(m, fromPercentile, toPercentile, pattern, filler);
            }
            case NORMALIZED_0_1_VALUE: {
                Matrix minV = Matrices.constantMatrix((double)(this.lowLimit * scale), DoubleArray.class, (long[])m.dimensions());
                Matrix maxV = Matrices.constantMatrix((double)(this.highLimit * scale), DoubleArray.class, (long[])m.dimensions());
                return morphology.meanBetweenValues(m, minV, maxV, pattern, filler);
            }
        }
        throw new AssertionError((Object)"Unknown limitInterpretation");
    }

    public static enum LimitInterpretation {
        NORMALIZED_0_1_PERCENTILE,
        NORMALIZED_0_1_VALUE;

    }
}

