/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import java.util.Locale;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.RankMorphologyFilter;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.filters3x3.PercentileBySquare3x3;
import net.algart.matrices.morphology.RankMorphology;

public final class Percentile
extends RankMorphologyFilter {
    private double percentile = 0.9;
    private ValueInterpretation valueInterpretation = ValueInterpretation.NORMALIZED_0_1;

    public double getPercentile() {
        return this.percentile;
    }

    public Percentile setPercentile(double percentile) {
        this.percentile = percentile;
        return this;
    }

    public ValueInterpretation getValueInterpretation() {
        return this.valueInterpretation;
    }

    public Percentile setValueInterpretation(ValueInterpretation valueInterpretation) {
        this.valueInterpretation = (ValueInterpretation)((Object)Percentile.nonNull((Object)((Object)valueInterpretation)));
        return this;
    }

    @Override
    protected Matrix<? extends PArray> processCompressedChannel(Matrix<? extends PArray> m) {
        Matrix result;
        long t2;
        Pattern pattern = this.getPattern(m);
        double percentileIndex = this.valueInterpretation == ValueInterpretation.ABSOLUTE_INDEX ? this.percentile : this.percentile * (double)(pattern.pointCount() - 1L);
        long t1 = Percentile.debugTime();
        if (this.getShape() == MorphologyFilter.Shape.CUBE && this.getPatternSize() == 3 && this.continuationMode == Matrix.ContinuationMode.CYCLIC && percentileIndex >= 0.0 && percentileIndex < (double)pattern.pointCount()) {
            PercentileBySquare3x3 percentile3x3 = PercentileBySquare3x3.newInstance((Class)m.elementType(), (long[])m.dimensions(), (int)((int)percentileIndex));
            t2 = Percentile.debugTime();
            result = percentile3x3.filter(m);
        } else {
            RankMorphology rankMorphology = this.createRankMorphology(m.elementType(), 1.0);
            t2 = Percentile.debugTime();
            result = rankMorphology.percentile(m, percentileIndex, pattern);
        }
        long t3 = Percentile.debugTime();
        if (this.currentChannel() == 0) {
            Percentile.logDebug(() -> String.format(Locale.US, "Percentile (index %.1f)%s with %s%s for %s: %.3f initializing + %.3f processing", percentileIndex, this.rankMorphologyLogMessage(), pattern, this.continuationMode == null ? "" : ", " + this.continuationMode, this.sourceMultiMatrix(), (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        }
        return result;
    }

    public static enum ValueInterpretation {
        ABSOLUTE_INDEX,
        NORMALIZED_0_1;

    }
}

