/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.cv.matrices.drawing.DrawEllipse;
import net.algart.executors.modules.cv.matrices.drawing.DrawRectangle;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.external.MatrixIO;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class AWTDrawingTest {
    private static final boolean BUFFERED_IMAGE_FROM_SMAT = true;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.printf("Usage: %s resultFile.png%n", AWTDrawingTest.class.getName());
            return;
        }
        String fileName = args[0];
        DrawEllipse drawEllipse = new DrawEllipse().setWidth(150.0).setHeight(100.0).setX(200.0).setY(200.0);
        drawEllipse.setColor(new Color(0x808080));
        BufferedImage bufferedImage = new BufferedImage(500, 500, 10);
        System.out.printf("bufferedImage:        %s%n  (%s: %s)%n", bufferedImage, bufferedImage.getColorModel().getClass().getName(), bufferedImage.getColorModel());
        SMat image = SMat.valueOf((BufferedImage)bufferedImage);
        image = new DrawRectangle().setColor("#808080").setLeft(0.0).setTop(0.0).setWidth(100.0).setHeight(100.0).process(image);
        System.out.printf("Writing %s%n", fileName + ".opencv_rect.png");
        opencv_imgcodecs.imwrite((String)(fileName + ".opencv_rect.png"), (Mat)O2SMat.toMat((SMat)image));
        bufferedImage = image.toBufferedImage();
        System.out.printf("New bufferedImage:    %s%n  (%s: %s)%n", bufferedImage, bufferedImage.getColorModel().getClass().getName(), bufferedImage.getColorModel());
        BufferedImage result = drawEllipse.process(bufferedImage);
        System.out.printf("Result bufferedImage: %s%n", bufferedImage);
        System.out.printf("Corner pixel in BufferedImage (getRGB): 0x%X%n", bufferedImage.getRGB(0, 0));
        System.out.printf("Center pixel in BufferedImage (getRGB): 0x%X%n", bufferedImage.getRGB((int)drawEllipse.getX(), (int)drawEllipse.getY()));
        System.out.printf("Writing %s%n", fileName);
        ImageIO.write((RenderedImage)result, MatrixIO.extension((String)fileName, (String)"png"), new File(fileName));
        SMat image2 = SMat.valueOf((BufferedImage)bufferedImage);
        System.out.printf("Corner pixel in MultiMatrix (getPixel): %s%n", image2.toMultiMatrix2D().getPixel(0L, 0L));
        System.out.printf("Center pixel in MultiMatrix (getPixel): %s%n", image2.toMultiMatrix2D().getPixel((long)drawEllipse.getX(), (long)drawEllipse.getY()));
        System.out.printf("Writing %s%n", fileName + ".opencv.png");
        opencv_imgcodecs.imwrite((String)(fileName + ".opencv.png"), (Mat)O2SMat.toMat((SMat)image2));
        bufferedImage = ImageIO.read(new File(fileName));
        System.out.printf("Loaded bufferedImage: %s%n  (%s: %s)%n", bufferedImage, bufferedImage.getColorModel().getClass().getName(), bufferedImage.getColorModel());
        System.out.printf("Corner pixel in BufferedImage (getRGB): 0x%X%n", bufferedImage.getRGB(0, 0));
        System.out.printf("Center pixel in BufferedImage (getRGB): 0x%X%n", bufferedImage.getRGB((int)drawEllipse.getX(), (int)drawEllipse.getY()));
    }
}

