/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2017-2024 Daniel Alievsky, AlgART Laboratory (http://algart.net)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.algart.executors.modules.opencv.matrices.arithmetic;

import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import net.algart.executors.api.ReadOnlyExecutionInput;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.*;

import java.io.File;

public final class Max extends VoidResultTwoUMatFilter implements ReadOnlyExecutionInput {
    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        opencv_core.max(source, secondMat, result);
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        opencv_core.max(source, secondMat, result);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.printf("Usage: %s source_image_1 source_image_2 target_image%n", Max.class.getName());
            return;
        }
        final File sourceFile1 = new File(args[0]);
        final File sourceFile2 = new File(args[1]);
        final File targetFile = new File(args[2]);
        final Mat mat1 = opencv_imgcodecs.imread(sourceFile1.getPath());
        final Mat mat2 = opencv_imgcodecs.imread(sourceFile2.getPath());
        final Mat res = new Mat();
        new Max().process(res, mat1, mat2);
        opencv_imgcodecs.imwrite(targetFile.getPath(), res);
    }
}
