/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public class GaussianBlur
extends UMatFilter {
    private int kernelSizeX = 15;
    private int kernelSizeY = 0;
    private double sigmaX = 0.0;
    private double sigmaY = 0.0;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;
    private boolean floatResult = false;
    private boolean convertToGrayscale = false;

    public int getKernelSizeX() {
        return this.kernelSizeX;
    }

    public GaussianBlur setKernelSizeX(int kernelSizeX) {
        this.kernelSizeX = GaussianBlur.nonNegative((int)kernelSizeX);
        return this;
    }

    public GaussianBlur setKernelSizeX(String kernelSizeX) {
        return this.setKernelSizeX(GaussianBlur.intOrDefault((String)kernelSizeX, (int)0));
    }

    public int getKernelSizeY() {
        return this.kernelSizeY;
    }

    public GaussianBlur setKernelSizeY(int kernelSizeY) {
        this.kernelSizeY = GaussianBlur.nonNegative((int)kernelSizeY);
        return this;
    }

    public GaussianBlur setKernelSizeY(String kernelSizeY) {
        return this.setKernelSizeY(GaussianBlur.intOrDefault((String)kernelSizeY, (int)0));
    }

    public double getSigmaX() {
        return this.sigmaX;
    }

    public GaussianBlur setSigmaX(double sigmaX) {
        this.sigmaX = GaussianBlur.nonNegative((double)sigmaX);
        return this;
    }

    public GaussianBlur setSigmaX(String sigmaX) {
        return this.setSigmaX(GaussianBlur.doubleOrDefault((String)sigmaX, (double)0.0));
    }

    public double getSigmaY() {
        return this.sigmaY;
    }

    public GaussianBlur setSigmaY(double sigmaY) {
        this.sigmaY = GaussianBlur.nonNegative((double)sigmaY);
        return this;
    }

    public GaussianBlur setSigmaY(String sigmaY) {
        return this.setSigmaY(GaussianBlur.doubleOrDefault((String)sigmaY, (double)0.0));
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public GaussianBlur setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)GaussianBlur.nonNull((Object)((Object)borderType)));
        return this;
    }

    public boolean isFloatResult() {
        return this.floatResult;
    }

    public GaussianBlur setFloatResult(boolean floatResult) {
        this.floatResult = floatResult;
        return this;
    }

    public boolean isConvertToGrayscale() {
        return this.convertToGrayscale;
    }

    public GaussianBlur setConvertToGrayscale(boolean convertToGrayscale) {
        this.convertToGrayscale = convertToGrayscale;
        return this;
    }

    @Override
    public Mat process(Mat source) {
        int sizeY;
        int sizeX;
        if (this.kernelSizeX == 0 && this.kernelSizeY == 0) {
            sizeX = 0;
            sizeY = 0;
        } else {
            sizeX = (this.kernelSizeX > 0 ? this.kernelSizeX : this.kernelSizeY) | 1;
            sizeY = (this.kernelSizeY > 0 ? this.kernelSizeY : this.kernelSizeX) | 1;
        }
        if (sizeX == 0 && sizeY == 0 && this.sigmaX == 0.0 && this.sigmaY == 0.0) {
            return source;
        }
        if (this.convertToGrayscale) {
            OTools.makeMonoIfNot(source);
        }
        if (this.floatResult) {
            OTools.make32FIfNot(source);
        }
        try (Size size = new Size(sizeX, sizeY);){
            opencv_imgproc.GaussianBlur((Mat)source, (Mat)source, (Size)size, (double)this.sigmaX, (double)this.sigmaY, (int)this.getBorderType().code());
            Mat mat = source;
            return mat;
        }
    }

    @Override
    public UMat process(UMat source) {
        int sizeY;
        int sizeX;
        if (this.kernelSizeX == 0 && this.kernelSizeY == 0) {
            sizeX = 0;
            sizeY = 0;
        } else {
            sizeX = (this.kernelSizeX > 0 ? this.kernelSizeX : this.kernelSizeY) | 1;
            sizeY = (this.kernelSizeY > 0 ? this.kernelSizeY : this.kernelSizeX) | 1;
        }
        if (sizeX == 0 && sizeY == 0 && this.sigmaX == 0.0 && this.sigmaY == 0.0) {
            return source;
        }
        if (this.convertToGrayscale) {
            OTools.makeMonoIfNot(source);
        }
        if (this.floatResult) {
            OTools.make32FIfNot(source);
        }
        try (Size size = new Size(sizeX, sizeY);){
            opencv_imgproc.GaussianBlur((UMat)source, (UMat)source, (Size)size, (double)this.sigmaX, (double)this.sigmaY, (int)this.getBorderType().code());
            UMat uMat = source;
            return uMat;
        }
    }

    public static MultiMatrix2D blur(MultiMatrix2D source, int kernelSizeX, int kernelSizeY, boolean floatResult) {
        return GaussianBlur.blur(source, kernelSizeX, kernelSizeY, 0.0, 0.0, floatResult, false);
    }

    public static MultiMatrix2D blur(MultiMatrix2D source, int kernelSize, boolean floatResult) {
        return GaussianBlur.blur(source, kernelSize, kernelSize, 0.0, 0.0, floatResult, false);
    }

    public static MultiMatrix2D blurGrayscale(MultiMatrix2D source, int kernelSizeX, int kernelSizeY, boolean floatResult) {
        return GaussianBlur.blur(source, kernelSizeX, kernelSizeY, 0.0, 0.0, floatResult, true);
    }

    public static MultiMatrix2D blurGrayscale(MultiMatrix2D source, int kernelSize, boolean floatResult) {
        return GaussianBlur.blur(source, kernelSize, kernelSize, 0.0, 0.0, floatResult, true);
    }

    public static MultiMatrix2D blur(MultiMatrix2D source, int kernelSizeX, int kernelSizeY, double sigmaX, double sigmaY, boolean floatResult, boolean convertToGrayscale) {
        try (GaussianBlur gaussianBlur = new GaussianBlur(){

            protected boolean loggingEnabled() {
                return false;
            }
        }.setKernelSizeX(kernelSizeX).setKernelSizeY(kernelSizeY).setSigmaX(sigmaX).setSigmaY(sigmaY).setFloatResult(floatResult).setConvertToGrayscale(convertToGrayscale);){
            if (OTools.isGPUOptimizationEnabled()) {
                UMat mat = O2SMat.toUMat(source);
                MultiMatrix2D multiMatrix2D = O2SMat.toMultiMatrix(gaussianBlur.process(mat));
                return multiMatrix2D;
            }
            Mat mat = O2SMat.toMat(source);
            MultiMatrix2D multiMatrix2D = O2SMat.toMultiMatrix(gaussianBlur.process(mat));
            return multiMatrix2D;
        }
    }

    public static void blurI\u05dePlace(SMat sourceAndResult, int kernelSizeX, int kernelSizeY, boolean floatResult) {
        GaussianBlur.blurI\u05dePlace(sourceAndResult, kernelSizeX, kernelSizeY, 0.0, 0.0, floatResult, false);
    }

    public static void blurI\u05dePlace(SMat sourceAndResult, int kernelSize, boolean floatResult) {
        GaussianBlur.blurI\u05dePlace(sourceAndResult, kernelSize, kernelSize, 0.0, 0.0, floatResult, false);
    }

    public static void blurGrayscaleInPlace(SMat sourceAndResult, int kernelSizeX, int kernelSizeY, boolean floatResult) {
        GaussianBlur.blurI\u05dePlace(sourceAndResult, kernelSizeX, kernelSizeY, 0.0, 0.0, floatResult, true);
    }

    public static void blurGrayscaleInPlace(SMat sourceAndResult, int kernelSize, boolean floatResult) {
        GaussianBlur.blurI\u05dePlace(sourceAndResult, kernelSize, kernelSize, 0.0, 0.0, floatResult, true);
    }

    public static void blurI\u05dePlace(SMat sourceAndResult, int kernelSizeX, int kernelSizeY, double sigmaX, double sigmaY, boolean floatResult, boolean convertToGrayscale) {
        try (GaussianBlur gaussianBlur = new GaussianBlur(){

            protected boolean loggingEnabled() {
                return false;
            }
        }.setKernelSizeX(kernelSizeX).setKernelSizeY(kernelSizeY).setSigmaX(sigmaX).setSigmaY(sigmaY).setFloatResult(floatResult).setConvertToGrayscale(convertToGrayscale);){
            if (OTools.isGPUOptimizationEnabled()) {
                UMat mat = O2SMat.toUMat(sourceAndResult);
                O2SMat.setTo(sourceAndResult, gaussianBlur.process(mat));
            } else {
                Mat mat = O2SMat.toMat(sourceAndResult);
                O2SMat.setTo(sourceAndResult, gaussianBlur.process(mat));
            }
        }
    }
}

