/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.arrays.ArraySelector;
import net.algart.arrays.ByteArraySelector;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannel;

class PercentilesFinderByLastChannelFor3ResultChannels
extends PercentilesFinderByLastChannel {
    private final boolean separateChannels0;
    private final boolean separateChannels1;
    private final boolean separateChannels2;

    PercentilesFinderByLastChannelFor3ResultChannels(int maxLabel, double[][] levels, int lowTruncatedMeanIndex, int highTruncatedMeanIndex, boolean[] separateChannelsSet) {
        super(5, maxLabel, levels, lowTruncatedMeanIndex, highTruncatedMeanIndex, separateChannelsSet);
        this.separateChannels0 = this.separateChannelsSet[0];
        this.separateChannels1 = this.separateChannelsSet[1];
        this.separateChannels2 = this.separateChannelsSet[2];
    }

    @Override
    public void processPixels(int objectLabel, byte[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int k = 0; k < this.commonLevels.length; ++k) {
                percentilesByChannel0[k][resultDisp] = Float.NaN;
                percentilesByChannel1[k][resultDisp] = Float.NaN;
                percentilesByChannel2[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeansByChannel0[resultDisp] = Float.NaN;
                truncatedMeansByChannel1[resultDisp] = Float.NaN;
                truncatedMeansByChannel2[resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        if (numberOfPixels >= 128) {
            this.percentilesForBytes(resultDisp, objectPixelsByChannels, numberOfPixels, this.threadBytePercentiles[threadIndex], this.threadByteArraySelectors[threadIndex]);
            return;
        }
        byte[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        byte[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        byte[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        byte[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        byte[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            byte selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += (double)(objectPixelsByChannel0[j] & 0xFF);
                sum1 += (double)(objectPixelsByChannel1[j] & 0xFF);
                sum2 += (double)(objectPixelsByChannel2[j] & 0xFF);
                ++count;
            }
            double countInv = 1.0 / (double)count;
            if (!this.separateChannels0) {
                percentilesByChannel0[k][resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[k][resultDisp] = (float)(sum1 * countInv);
            }
            if (this.separateChannels2) continue;
            percentilesByChannel2[k][resultDisp] = (float)(sum2 * countInv);
        }
        if (this.needTruncatedMeans) {
            byte preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            byte preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow & 0xFF;
            double high = preciseHigh & 0xFF;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                byte precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFF;
                double channel0 = objectPixelsByChannel0[j] & 0xFF;
                double channel1 = objectPixelsByChannel1[j] & 0xFF;
                double channel2 = objectPixelsByChannel2[j] & 0xFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }

    @Override
    public void processPixels(int objectLabel, short[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int k = 0; k < this.commonLevels.length; ++k) {
                percentilesByChannel0[k][resultDisp] = Float.NaN;
                percentilesByChannel1[k][resultDisp] = Float.NaN;
                percentilesByChannel2[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeansByChannel0[resultDisp] = Float.NaN;
                truncatedMeansByChannel1[resultDisp] = Float.NaN;
                truncatedMeansByChannel2[resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        short[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        short[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        short[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        short[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        short[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            short selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += (double)(objectPixelsByChannel0[j] & 0xFFFF);
                sum1 += (double)(objectPixelsByChannel1[j] & 0xFFFF);
                sum2 += (double)(objectPixelsByChannel2[j] & 0xFFFF);
                ++count;
            }
            double countInv = 1.0 / (double)count;
            if (!this.separateChannels0) {
                percentilesByChannel0[k][resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[k][resultDisp] = (float)(sum1 * countInv);
            }
            if (this.separateChannels2) continue;
            percentilesByChannel2[k][resultDisp] = (float)(sum2 * countInv);
        }
        if (this.needTruncatedMeans) {
            short preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            short preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow & 0xFFFF;
            double high = preciseHigh & 0xFFFF;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                short precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFFFF;
                double channel0 = objectPixelsByChannel0[j] & 0xFFFF;
                double channel1 = objectPixelsByChannel1[j] & 0xFFFF;
                double channel2 = objectPixelsByChannel2[j] & 0xFFFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }

    @Override
    public void processPixels(int objectLabel, int[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int k = 0; k < this.commonLevels.length; ++k) {
                percentilesByChannel0[k][resultDisp] = Float.NaN;
                percentilesByChannel1[k][resultDisp] = Float.NaN;
                percentilesByChannel2[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeansByChannel0[resultDisp] = Float.NaN;
                truncatedMeansByChannel1[resultDisp] = Float.NaN;
                truncatedMeansByChannel2[resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        int[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        int[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        int[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        int[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        int[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            int selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += (double)objectPixelsByChannel0[j];
                sum1 += (double)objectPixelsByChannel1[j];
                sum2 += (double)objectPixelsByChannel2[j];
                ++count;
            }
            double countInv = 1.0 / (double)count;
            if (!this.separateChannels0) {
                percentilesByChannel0[k][resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[k][resultDisp] = (float)(sum1 * countInv);
            }
            if (this.separateChannels2) continue;
            percentilesByChannel2[k][resultDisp] = (float)(sum2 * countInv);
        }
        if (this.needTruncatedMeans) {
            int preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            int preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                int precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel;
                double channel0 = objectPixelsByChannel0[j];
                double channel1 = objectPixelsByChannel1[j];
                double channel2 = objectPixelsByChannel2[j];
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }

    @Override
    public void processPixels(int objectLabel, float[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int k = 0; k < this.commonLevels.length; ++k) {
                percentilesByChannel0[k][resultDisp] = Float.NaN;
                percentilesByChannel1[k][resultDisp] = Float.NaN;
                percentilesByChannel2[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeansByChannel0[resultDisp] = Float.NaN;
                truncatedMeansByChannel1[resultDisp] = Float.NaN;
                truncatedMeansByChannel2[resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        float[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        float[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        float[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        float[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        float[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            float selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += (double)objectPixelsByChannel0[j];
                sum1 += (double)objectPixelsByChannel1[j];
                sum2 += (double)objectPixelsByChannel2[j];
                ++count;
            }
            double countInv = 1.0 / (double)count;
            if (!this.separateChannels0) {
                percentilesByChannel0[k][resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[k][resultDisp] = (float)(sum1 * countInv);
            }
            if (this.separateChannels2) continue;
            percentilesByChannel2[k][resultDisp] = (float)(sum2 * countInv);
        }
        if (this.needTruncatedMeans) {
            float preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            float preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                float precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel;
                double channel0 = objectPixelsByChannel0[j];
                double channel1 = objectPixelsByChannel1[j];
                double channel2 = objectPixelsByChannel2[j];
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }

    @Override
    public void processPixels(int objectLabel, double[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        int resultDisp = objectLabel - 1;
        if (numberOfPixels == 0) {
            for (int k = 0; k < this.commonLevels.length; ++k) {
                percentilesByChannel0[k][resultDisp] = Float.NaN;
                percentilesByChannel1[k][resultDisp] = Float.NaN;
                percentilesByChannel2[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeansByChannel0[resultDisp] = Float.NaN;
                truncatedMeansByChannel1[resultDisp] = Float.NaN;
                truncatedMeansByChannel2[resultDisp] = Float.NaN;
            }
            return;
        }
        this.processSeparatedPercentiles(resultDisp, objectPixelsByChannels, numberOfPixels, threadIndex);
        double[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        double[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        double[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        double[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        double[] sortedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels + 1];
        ArraySelector.getQuickSelector().select(this.commonSortedLevels, sortedObjectPixelLevels, numberOfPixels);
        for (int k = 0; k < this.commonLevels.length; ++k) {
            if (this.needTruncatedMeans && (k == this.lowTruncatedMeanIndex || k == this.highTruncatedMeanIndex)) continue;
            double selectedLevel = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[k], (int)numberOfPixels)];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += objectPixelsByChannel0[j];
                sum1 += objectPixelsByChannel1[j];
                sum2 += objectPixelsByChannel2[j];
                ++count;
            }
            double countInv = 1.0 / (double)count;
            if (!this.separateChannels0) {
                percentilesByChannel0[k][resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[k][resultDisp] = (float)(sum1 * countInv);
            }
            if (this.separateChannels2) continue;
            percentilesByChannel2[k][resultDisp] = (float)(sum2 * countInv);
        }
        if (this.needTruncatedMeans) {
            double preciseLow = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.lowTruncatedMeanIndex], (int)numberOfPixels)];
            double preciseHigh = sortedObjectPixelLevels[ArraySelector.percentileIndex((double)this.commonLevels[this.highTruncatedMeanIndex], (int)numberOfPixels)];
            double low = preciseLow;
            double high = preciseHigh;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                double precisePixelLevel;
                double pixelLevel = precisePixelLevel = unchangedObjectPixelLevels[j];
                double channel0 = objectPixelsByChannel0[j];
                double channel1 = objectPixelsByChannel1[j];
                double channel2 = objectPixelsByChannel2[j];
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }

    private void percentilesForBytes(int resultDisp, byte[][] objectPixelsByChannels, int numberOfPixels, byte[] bytePercentiles, ByteArraySelector selector) {
        byte[] unchangedObjectPixelLevels = objectPixelsByChannels[this.numberOfResultChannels];
        selector.select(bytePercentiles, this.commonSortedLevels, unchangedObjectPixelLevels, numberOfPixels);
        float[][] percentilesByChannel0 = this.percentilesByChannels[0];
        float[][] percentilesByChannel1 = this.percentilesByChannels[1];
        float[][] percentilesByChannel2 = this.percentilesByChannels[2];
        float[] truncatedMeansByChannel0 = this.needTruncatedMeans ? this.truncatedMeansByChannels[0] : null;
        float[] truncatedMeansByChannel1 = this.needTruncatedMeans ? this.truncatedMeansByChannels[1] : null;
        float[] truncatedMeansByChannel2 = this.needTruncatedMeans ? this.truncatedMeansByChannels[2] : null;
        byte[] objectPixelsByChannel0 = objectPixelsByChannels[0];
        byte[] objectPixelsByChannel1 = objectPixelsByChannels[1];
        byte[] objectPixelsByChannel2 = objectPixelsByChannels[2];
        int kLow = -1;
        int kHigh = -1;
        for (int k = 0; k < this.commonLevels.length; ++k) {
            boolean isHigh;
            int unsortedIndex = this.commonUnsortedLevelsIndexes[k];
            boolean isLow = unsortedIndex == this.lowTruncatedMeanIndex;
            boolean bl = isHigh = unsortedIndex == this.highTruncatedMeanIndex;
            if (this.needTruncatedMeans && (isLow || isHigh)) {
                if (isLow) {
                    kLow = k;
                }
                if (!isHigh) continue;
                kHigh = k;
                continue;
            }
            byte selectedLevel = bytePercentiles[k];
            double sum0 = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                if (unchangedObjectPixelLevels[j] != selectedLevel) continue;
                sum0 += (double)(objectPixelsByChannel0[j] & 0xFF);
                sum1 += (double)(objectPixelsByChannel1[j] & 0xFF);
                sum2 += (double)(objectPixelsByChannel2[j] & 0xFF);
                ++count;
            }
            double countInv = 1.0 / (double)count;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                if (!this.separateChannels0) {
                    percentilesByChannel0[unsortedIndex][resultDisp] = (float)(sum0 * countInv);
                }
                if (!this.separateChannels1) {
                    percentilesByChannel1[unsortedIndex][resultDisp] = (float)(sum1 * countInv);
                }
                if (this.separateChannels2) continue;
                percentilesByChannel2[unsortedIndex][resultDisp] = (float)(sum2 * countInv);
            }
        }
        if (this.needTruncatedMeans) {
            assert (kLow >= 0);
            assert (kHigh >= 0);
            byte preciseLow = bytePercentiles[kLow];
            byte preciseHigh = bytePercentiles[kHigh];
            double low = preciseLow & 0xFF;
            double high = preciseHigh & 0xFF;
            double sum0 = 0.0;
            double sumLow0 = 0.0;
            double sumHigh0 = 0.0;
            double sum1 = 0.0;
            double sumLow1 = 0.0;
            double sumHigh1 = 0.0;
            double sum2 = 0.0;
            double sumLow2 = 0.0;
            double sumHigh2 = 0.0;
            int count = 0;
            int countLow = 0;
            int countHigh = 0;
            for (int j = 0; j < numberOfPixels; ++j) {
                byte precisePixelLevel = unchangedObjectPixelLevels[j];
                double pixelLevel = precisePixelLevel & 0xFF;
                double channel0 = objectPixelsByChannel0[j] & 0xFF;
                double channel1 = objectPixelsByChannel1[j] & 0xFF;
                double channel2 = objectPixelsByChannel2[j] & 0xFF;
                if (pixelLevel >= low && pixelLevel <= high) {
                    sum0 += channel0;
                    sum1 += channel1;
                    sum2 += channel2;
                    ++count;
                }
                if (precisePixelLevel == preciseLow) {
                    sumLow0 += channel0;
                    sumLow1 += channel1;
                    sumLow2 += channel2;
                    ++countLow;
                }
                if (precisePixelLevel != preciseHigh) continue;
                sumHigh0 += channel0;
                sumHigh1 += channel1;
                sumHigh2 += channel2;
                ++countHigh;
            }
            double countInv = 1.0 / (double)count;
            double countLowInv = 1.0 / (double)countLow;
            double countHighInv = 1.0 / (double)countHigh;
            if (!this.separateChannels0) {
                percentilesByChannel0[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow0 * countLowInv);
                percentilesByChannel0[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh0 * countHighInv);
                truncatedMeansByChannel0[resultDisp] = (float)(sum0 * countInv);
            }
            if (!this.separateChannels1) {
                percentilesByChannel1[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow1 * countLowInv);
                percentilesByChannel1[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh1 * countHighInv);
                truncatedMeansByChannel1[resultDisp] = (float)(sum1 * countInv);
            }
            if (!this.separateChannels2) {
                percentilesByChannel2[this.lowTruncatedMeanIndex][resultDisp] = (float)(sumLow2 * countLowInv);
                percentilesByChannel2[this.highTruncatedMeanIndex][resultDisp] = (float)(sumHigh2 * countHighInv);
                truncatedMeansByChannel2[resultDisp] = (float)(sum2 * countInv);
            }
        }
    }
}

